/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIRange;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class RangeRenderer<T extends AbstractUIRange>
extends DecorationPositionRendererBase<T> {
    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIInput)component).isDisabled() || ((AbstractUIInput)component).isReadonly();
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_RANGE;
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String currentValue = this.getCurrentValue(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUIInput)component).getFieldId(facesContext);
        boolean readonly = ((AbstractUIInput)component).isReadonly();
        boolean disabled = ((AbstractUIInput)component).isDisabled();
        int min = ((AbstractUIRange)component).getMin();
        int max = ((AbstractUIRange)component).getMax();
        int step = ((AbstractUIRange)component).getStep();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.TOOLTIP, BootstrapClass.FADE);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.INPUT);
        if (component.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(component.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, component.getAccessKey(), clientId);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RANGE);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (currentValue != null) {
            writer.writeAttribute(HtmlAttributes.VALUE, currentValue, true);
        }
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUIInput)component).getTabIndex());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MIN, min);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAX, max);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.STEP, step);
        CssItem rendererCssClass = this.getRendererCssClass();
        writer.writeClassAttribute(rendererCssClass, BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity(component)), BootstrapClass.FORM_RANGE, component.getCustomClass());
        RangeRenderer.renderFocus(clientId, ((AbstractUIInput)component).isFocus(), ((AbstractUIInput)component).isError(), facesContext, writer);
        writer.endElement(HtmlElements.INPUT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
    }

    protected CssItem getRendererCssClass() {
        return TobagoClass.RANGE;
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUIInput)component).getFieldId(facesContext);
    }
}

