/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeInvalidViewPathException;
import javax.portlet.faces.BridgeUtil;
import org.apache.myfaces.portlet.faces.util.FacesVersionUtil;
import org.apache.myfaces.portlet.faces.util.QueryString;
import org.apache.myfaces.portlet.faces.util.URLUtils;
import org.apache.myfaces.portlet.faces.util.map.EnumerationIterator;
import org.apache.myfaces.portlet.faces.util.map.PortletApplicationMap;
import org.apache.myfaces.portlet.faces.util.map.PortletInitParameterMap;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestHeaderMap;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestHeaderValuesMap;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestHeaders;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestMap;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestParameterMap;
import org.apache.myfaces.portlet.faces.util.map.PortletRequestParameterValuesMap;
import org.apache.myfaces.portlet.faces.util.map.PortletSessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExternalContextImpl
extends ExternalContext {
    public static final String FACES_MAPPING_ATTRIBUTE = "org.apache.myfaces.portlet.faces.context.facesMapping";
    private static final String ENCODED_ACTION_URL_ATTRIBUTE_PREFIX = "org.apache.myfaces.portlet.faces.context.";
    public static final String RENDER_POLICY_ATTRIBUTE = "javax.portlet.faces..javax.portlet.faces.RENDER_POLICY";
    public static final String JSF_TARGET_VIEWID_RENDER_PARAMETER = "__jpfbJSFTARGET";
    public static final String NO_SCOPE = "org.apache.myfaces.portlet.faces.noScope";
    public static final String SERVLET_INCLUDED_PATHINFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String SERVLET_INCLUDED_SERVLETPATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private static final String LIFERAY_NAMESPACE_PREFIX_HACK = "lfr_";
    private PortletContext mPortletContext;
    private PortletRequest mPortletRequest;
    private PortletResponse mPortletResponse;
    private Object mTempNonPortletResponse;
    private String mPortletName;
    private PortletRequest mOrigPortletRequest = null;
    private PortletResponse mOrigPortletResponse = null;
    private Map<String, Object> mApplicationMap = null;
    private Map<String, Object> mSessionMap = null;
    private Map<String, Object> mRequestMap = null;
    private Map<String, String> mRequestParameterMap = null;
    private Map<String, String[]> mRequestParameterValuesMap = null;
    private Map<String, String> mRequestHeaderMap = null;
    private Map<String, String[]> mRequestHeaderValuesMap = null;
    private Map<String, String> mInitParameterMap = null;
    private Map<String, String> mTempExtraRequestParameterMap = Collections.emptyMap();
    private Map<String, String[]> mTempExtraRequestParameterValuesMap = Collections.emptyMap();
    private PortletRequestHeaders mPortletRequestHeaders = null;
    private String mViewId = null;
    private List<String> mFacesMappings = null;
    private String mServletPath = null;
    private String mPathInfo = null;
    private String mIncludedServletPath = null;
    private String mIncludedPathInfo = null;
    private boolean mUseIncludeAttributeServletDependencyWorkaround;

    public PortletExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) throws FacesException {
        this.mPortletContext = portletContext;
        this.mPortletRequest = this.mOrigPortletRequest = portletRequest;
        this.mPortletResponse = this.mOrigPortletResponse = portletResponse;
        this.mPortletName = (String)this.mPortletRequest.getAttribute("org.apache.myfaces.portlet.faces.portletName");
        this.mFacesMappings = (List)this.mPortletRequest.getAttribute(FACES_MAPPING_ATTRIBUTE);
        this.setFacesVersionDependencyFlags();
        this.mIncludedPathInfo = (String)this.mPortletRequest.getAttribute(SERVLET_INCLUDED_PATHINFO_ATTRIBUTE);
        this.mIncludedServletPath = (String)this.mPortletRequest.getAttribute(SERVLET_INCLUDED_SERVLETPATH_ATTRIBUTE);
        this.mPortletRequest.removeAttribute(SERVLET_INCLUDED_PATHINFO_ATTRIBUTE);
        this.mPortletRequest.removeAttribute(SERVLET_INCLUDED_SERVLETPATH_ATTRIBUTE);
    }

    private void setFacesVersionDependencyFlags() {
        this.mUseIncludeAttributeServletDependencyWorkaround = true;
        String disable = this.mPortletContext.getInitParameter("org.apache.myfaces.portlet.bridge.disableMojarraViewResolutionWorkaround");
        if (disable != null) {
            this.mUseIncludeAttributeServletDependencyWorkaround = Boolean.valueOf(disable) == false;
        } else {
            switch (FacesVersionUtil.getFacesType()) {
                case MOJARRA: {
                    if (FacesVersionUtil.getFacesImplPatchVersion() < 13) break;
                    this.mUseIncludeAttributeServletDependencyWorkaround = false;
                    break;
                }
                case MYFACES: {
                    this.mUseIncludeAttributeServletDependencyWorkaround = false;
                    break;
                }
                default: {
                    this.mUseIncludeAttributeServletDependencyWorkaround = true;
                }
            }
        }
    }

    public void release() {
        if (this.mIncludedPathInfo != null) {
            this.mPortletRequest.setAttribute(SERVLET_INCLUDED_PATHINFO_ATTRIBUTE, (Object)this.mIncludedPathInfo);
        }
        if (this.mIncludedServletPath != null) {
            this.mPortletRequest.setAttribute(SERVLET_INCLUDED_SERVLETPATH_ATTRIBUTE, (Object)this.mIncludedServletPath);
        }
        this.mPortletContext = null;
        this.mPortletRequest = null;
        this.mPortletResponse = null;
        this.mOrigPortletRequest = null;
        this.mOrigPortletResponse = null;
        this.mApplicationMap = null;
        this.mSessionMap = null;
        this.mRequestMap = null;
        this.mRequestParameterMap = null;
        this.mRequestParameterValuesMap = null;
        this.mRequestHeaderMap = null;
        this.mRequestHeaderValuesMap = null;
        this.mInitParameterMap = null;
        this.mViewId = null;
    }

    public String encodeActionURL(String url) {
        QueryString queryStr;
        block37: {
            block35: {
                block36: {
                    FacesContext ctx = FacesContext.getCurrentInstance();
                    String viewId = null;
                    String path = null;
                    queryStr = null;
                    int queryStart = -1;
                    boolean isPortletURL = false;
                    boolean isPortletURLSelfReference = false;
                    boolean isStrictXhtmlEncoded = this.isStrictXhtmlEncoded(url);
                    Bridge.PortletPhase urlType = Bridge.PortletPhase.ACTION_PHASE;
                    if (this.isPortletURL(url)) {
                        isPortletURL = true;
                        path = url.substring(url.indexOf(":") + 1);
                        queryStart = path.indexOf(63);
                        if (queryStart != -1) {
                            queryStr = new QueryString(path.substring(queryStart + 1), "UTF8");
                            path = path.substring(0, queryStart);
                        }
                        if (path.equalsIgnoreCase("render")) {
                            urlType = Bridge.PortletPhase.RENDER_PHASE;
                        } else if (path.equalsIgnoreCase("action")) {
                            urlType = Bridge.PortletPhase.ACTION_PHASE;
                        } else {
                            this.log("PortletExternalContextImpl.encodeActionURL:  malformed portlet url " + url);
                            return url;
                        }
                        String s = queryStr.getParameter("_jsfBridgeViewId");
                        String s1 = queryStr.getParameter("_jsfBridgeViewPath");
                        if (s != null && s.equals("_jsfBridgeCurrentView")) {
                            isPortletURLSelfReference = true;
                            queryStr.removeParameter("_jsfBridgeViewId");
                        } else if (s != null && s1.equals("_jsfBridgeCurrentView")) {
                            isPortletURLSelfReference = true;
                            queryStr.removeParameter("_jsfBridgeViewPath");
                        }
                    } else {
                        if (url.startsWith("#") || this.isExternalURL(url) || this.isDirectLink(url)) {
                            return url;
                        }
                        queryStart = (url = this.removeDirectLink(url)).indexOf(63);
                        if (queryStart != -1) {
                            queryStr = new QueryString(url.substring(queryStart + 1), "UTF8");
                            path = url.substring(0, queryStart);
                        } else {
                            path = url;
                            queryStr = new QueryString("UTF8");
                        }
                        if (this.isRelativePath(path)) {
                            path = this.getPathFromRelativePath(path);
                        }
                        if ((viewId = this.getViewIdFromPath(path)) != null) {
                            this.encodeFacesActionTarget(queryStr, viewId);
                        } else {
                            this.encodeNonFacesActionTarget(queryStr, path);
                        }
                    }
                    if (this.getPortletPhase() != Bridge.PortletPhase.RENDER_PHASE) break block35;
                    RenderResponse renderResponse = (RenderResponse)this.getResponse();
                    PortletURL actionURL = null;
                    actionURL = urlType == Bridge.PortletPhase.ACTION_PHASE ? renderResponse.createActionURL() : renderResponse.createRenderURL();
                    Enumeration<String> list = queryStr.getParameterNames();
                    while (list.hasMoreElements()) {
                        String param = list.nextElement().toString();
                        if (param.equals("javax.portlet.faces.PortletMode")) {
                            try {
                                actionURL.setPortletMode(new PortletMode(queryStr.getParameter(param)));
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        if (param.equals("javax.portlet.faces.WindowState")) {
                            try {
                                actionURL.setWindowState(new WindowState(queryStr.getParameter(param)));
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        if (param.equals("javax.portlet.faces.Secure")) {
                            try {
                                actionURL.setSecure(Boolean.getBoolean(queryStr.getParameter(param)));
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        actionURL.setParameter(param, queryStr.getParameter(param));
                    }
                    if (isPortletURLSelfReference) {
                        Map m = this.mOrigPortletRequest.getParameterMap();
                        Set s = m.entrySet();
                        for (Map.Entry entry : s) {
                            if (queryStr.getParameter((String)entry.getKey()) != null) continue;
                            actionURL.setParameter((String)entry.getKey(), (String[])entry.getValue());
                        }
                    }
                    url = actionURL.toString();
                    if (isStrictXhtmlEncoded) break block36;
                    url = url.replace("&amp;", "&");
                    break block37;
                }
                if (this.isStrictXhtmlEncoded(url)) break block37;
                url = this.xhtmlEncode(url);
                break block37;
            }
            ActionResponse actionResponse = (ActionResponse)this.getResponse();
            Enumeration<String> list = queryStr.getParameterNames();
            while (list.hasMoreElements()) {
                String param = list.nextElement();
                if (param.equals("javax.portlet.faces.PortletMode")) {
                    try {
                        actionResponse.setPortletMode(new PortletMode(queryStr.getParameter(param)));
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (param.equals("javax.portlet.faces.WindowState")) {
                    try {
                        actionResponse.setWindowState(new WindowState(queryStr.getParameter(param)));
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (param.equals("javax.portlet.faces.Secure")) continue;
                actionResponse.setRenderParameter(param, queryStr.getParameter(param));
            }
        }
        this.getRequestMap().put(ENCODED_ACTION_URL_ATTRIBUTE_PREFIX.concat(url.replace(".", "*")), queryStr);
        return url;
    }

    public void redirect(String url) throws IOException {
        QueryString params = (QueryString)this.getRequestMap().get(ENCODED_ACTION_URL_ATTRIBUTE_PREFIX.concat(url.replace(".", "*")));
        if (params != null) {
            String target;
            if (this.getPortletPhase() == Bridge.PortletPhase.RENDER_PHASE && (target = params.getParameter(JSF_TARGET_VIEWID_RENDER_PARAMETER)) == null) {
                throw new IllegalStateException("Can't redirect during render to a NonFaces target: " + target);
            }
            this.getRequestMap().put("org.apache.myfaces.portlet.faces.redirectViewParams", params);
            FacesContext.getCurrentInstance().responseComplete();
        } else if (url.startsWith("#") || this.isExternalURL(url) || this.isDirectLink(url)) {
            if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
                ((ActionResponse)this.getResponse()).sendRedirect(url);
                FacesContext.getCurrentInstance().responseComplete();
            }
        } else {
            this.redirect(this.encodeActionURL(url));
        }
    }

    public String encodeResourceURL(String s) {
        if (this.isPortletURL(s)) {
            return this.urlEncode(this.encodeResourceAsViewNavigationURL(s));
        }
        if (this.isOpaqueURL(s)) {
            return s;
        }
        if (this.isExternalURL(s)) {
            return this.urlEncode(this.encodeResourceURL(s, false));
        }
        if (this.isViewLink(s)) {
            return this.urlEncode(this.encodeResourceAsViewNavigationURL(s));
        }
        return this.urlEncode(this.encodeResourceURL(s, true));
    }

    private String urlEncode(String s) {
        return s.replace(" ", "%20");
    }

    private String encodeResourceURL(String s, boolean targetInApp) {
        boolean isStrictXhtmlEncoded = this.isStrictXhtmlEncoded(s);
        if (targetInApp) {
            s = this.normalizeResourcePath(s);
        }
        s = this.replaceResourceQueryStringMarkers(s);
        if (!isStrictXhtmlEncoded) {
            return this.mPortletResponse.encodeURL(s).replace("&amp;", "&");
        }
        return this.xhtmlEncode(this.mPortletResponse.encodeURL(s));
    }

    private String normalizeResourcePath(String s) {
        String ctxPath;
        if (!s.startsWith("/")) {
            String pi = null;
            String path = this.getRequestServletPath();
            if (path == null) {
                path = this.getRequestPathInfo();
            } else {
                pi = this.getRequestPathInfo();
            }
            if (pi != null) {
                path = path.concat(pi);
            }
            path = path.substring(0, path.lastIndexOf("/"));
            s = URLUtils.convertFromRelative(path, s);
        }
        if ((ctxPath = this.getRequestContextPath()).length() > 0 && !s.startsWith(ctxPath)) {
            s = ctxPath + s;
        }
        return s;
    }

    private String encodeResourceAsViewNavigationURL(String s) {
        s = this.replaceResourceQueryStringMarkers(s);
        return this.encodeActionURL(s);
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        if (requestURI == null) {
            throw new NullPointerException();
        }
        if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            throw new IllegalStateException("Request cannot be an ActionRequest");
        }
        PortletRequestDispatcher prd = this.mPortletContext.getRequestDispatcher(requestURI);
        if (prd == null) {
            throw new IllegalArgumentException("No request dispatcher can be created for the specified path: " + requestURI);
        }
        try {
            prd.include((RenderRequest)this.mOrigPortletRequest, (RenderResponse)this.mOrigPortletResponse);
        }
        catch (PortletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public Object getSession(boolean create) {
        return this.mPortletRequest.getPortletSession(create);
    }

    public Object getContext() {
        return this.mPortletContext;
    }

    public Object getRequest() {
        return this.mPortletRequest;
    }

    public Object getResponse() {
        if (this.mTempNonPortletResponse != null) {
            return this.mTempNonPortletResponse;
        }
        return this.mPortletResponse;
    }

    public Map<String, Object> getApplicationMap() {
        if (this.mApplicationMap == null) {
            this.mApplicationMap = new PortletApplicationMap(this.mPortletContext);
        }
        return this.mApplicationMap;
    }

    public Map<String, Object> getSessionMap() {
        if (this.mSessionMap == null) {
            this.mSessionMap = new PortletSessionMap(this.mPortletRequest);
        }
        return this.mSessionMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this.mRequestMap == null) {
            this.mRequestMap = new PortletRequestMap(this.mPortletRequest);
        }
        return this.mRequestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this.mRequestParameterMap == null) {
            this.mRequestParameterMap = Collections.unmodifiableMap(new PortletRequestParameterMap(this.mPortletRequest, this.mTempExtraRequestParameterMap));
            this.mTempExtraRequestParameterMap = null;
        }
        return this.mRequestParameterMap;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.mRequestParameterValuesMap == null) {
            this.mRequestParameterValuesMap = Collections.unmodifiableMap(new PortletRequestParameterValuesMap(this.mPortletRequest, this.mTempExtraRequestParameterValuesMap));
            this.mTempExtraRequestParameterValuesMap = null;
        }
        return this.mRequestParameterValuesMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return this.getRequestParameterMap().keySet().iterator();
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.mRequestHeaderMap == null) {
            if (this.mPortletRequestHeaders == null) {
                this.mPortletRequestHeaders = new PortletRequestHeaders(this.mOrigPortletRequest);
            }
            this.mRequestHeaderMap = new PortletRequestHeaderMap(this.mPortletRequestHeaders);
        }
        return this.mRequestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.mRequestHeaderValuesMap == null) {
            if (this.mPortletRequestHeaders == null) {
                this.mPortletRequestHeaders = new PortletRequestHeaders(this.mOrigPortletRequest);
            }
            this.mRequestHeaderValuesMap = new PortletRequestHeaderValuesMap(this.mPortletRequestHeaders);
        }
        return this.mRequestHeaderValuesMap;
    }

    public Map<String, Object> getRequestCookieMap() {
        Map<String, Object> dummy = Collections.emptyMap();
        return dummy;
    }

    public Locale getRequestLocale() {
        return this.mPortletRequest.getLocale();
    }

    public String getRequestPathInfo() {
        if (this.mViewId == null) {
            this.determineView(true);
        }
        return this.mPathInfo;
    }

    public String getRequestContextPath() {
        return this.mPortletRequest.getContextPath();
    }

    public String getInitParameter(String s) {
        return this.mPortletContext.getInitParameter(s);
    }

    public Map<String, String> getInitParameterMap() {
        if (this.mInitParameterMap == null) {
            this.mInitParameterMap = new PortletInitParameterMap(this.mPortletContext);
        }
        return this.mInitParameterMap;
    }

    public Set<String> getResourcePaths(String s) {
        return this.mPortletContext.getResourcePaths(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this.mPortletContext.getResourceAsStream(s);
    }

    public String encodeNamespace(String s) {
        if (BridgeUtil.getPortletRequestPhase() != Bridge.PortletPhase.RENDER_PHASE) {
            throw new IllegalStateException("Only RenderResponse can be used to encode a namespace");
        }
        if (this.getRequestMap().get("THEME_DISPLAY") == null) {
            return ((RenderResponse)this.mPortletResponse).getNamespace() + s;
        }
        return LIFERAY_NAMESPACE_PREFIX_HACK + ((RenderResponse)this.mPortletResponse).getNamespace() + s;
    }

    public String getRequestServletPath() {
        if (this.mViewId == null) {
            this.determineView(true);
        }
        return this.mServletPath;
    }

    public String getAuthType() {
        return this.mPortletRequest.getAuthType();
    }

    public String getRemoteUser() {
        return this.mPortletRequest.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.mPortletRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.mPortletRequest.getUserPrincipal();
    }

    public void log(String message) {
        this.mPortletContext.log(message);
    }

    public void log(String message, Throwable t) {
        this.mPortletContext.log(message, t);
    }

    public Iterator<Locale> getRequestLocales() {
        return new EnumerationIterator<Locale>(this.mPortletRequest.getLocales());
    }

    public URL getResource(String s) throws MalformedURLException {
        return this.mPortletContext.getResource(s);
    }

    public void setRequest(Object request) {
        this.mPortletRequest = (PortletRequest)request;
        this.mRequestMap = null;
        this.mRequestParameterMap = null;
        this.mRequestParameterValuesMap = null;
        this.mRequestHeaderMap = null;
        this.mRequestHeaderValuesMap = null;
        if (this.mViewId != null) {
            this.determineView(false);
        }
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            try {
                ((ActionRequest)this.mPortletRequest).setCharacterEncoding(encoding);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public String getRequestCharacterEncoding() {
        if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            return ((ActionRequest)this.mPortletRequest).getCharacterEncoding();
        }
        return null;
    }

    public String getRequestContentType() {
        if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            return ((ActionRequest)this.mPortletRequest).getContentType();
        }
        return null;
    }

    public String getResponseCharacterEncoding() {
        if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            throw new IllegalStateException("PortletExternalContextImpl.getResponseCharacterEncoding(): Response must be a RenderRequest");
        }
        return ((RenderResponse)this.mPortletResponse).getCharacterEncoding();
    }

    public String getResponseContentType() {
        if (this.getPortletPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            throw new IllegalStateException("PortletExternalContextImpl.getResponseContentType(): Response must be a RenderRequest");
        }
        return ((RenderResponse)this.mPortletResponse).getContentType();
    }

    public void setResponse(Object response) {
        if (response instanceof PortletResponse) {
            this.mPortletResponse = (PortletResponse)response;
            this.mTempNonPortletResponse = null;
        } else {
            this.mTempNonPortletResponse = response;
        }
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    private Bridge.PortletPhase getPortletPhase() {
        return (Bridge.PortletPhase)this.getRequestMap().get("javax.portlet.faces.phase");
    }

    private String getViewId(boolean updateHistory) throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        boolean modeChanged = false;
        String requestedMode = this.mPortletRequest.getPortletMode().toString();
        String viewId = (String)this.mPortletRequest.getAttribute("javax.portlet.faces.viewId");
        String viewPath = null;
        if (viewId == null && (viewPath = (String)this.mPortletRequest.getAttribute("javax.portlet.faces.viewPath")) != null && (viewId = this.getViewIdFromPath(viewPath)) == null) {
            throw new BridgeInvalidViewPathException("Unable to resolve faces viewId: " + viewPath);
        }
        if (viewId == null) {
            int i;
            viewId = this.mPortletRequest.getParameter(JSF_TARGET_VIEWID_RENDER_PARAMETER);
            this.log("PortletExternalContextImpl.getViewId: found jsf target viewId = " + viewId);
            if (viewId != null && (i = viewId.indexOf(58)) >= 0) {
                String mode = viewId.substring(0, i);
                viewId = viewId.substring(i + 1);
                if (!mode.equalsIgnoreCase(requestedMode)) {
                    modeChanged = true;
                    viewId = null;
                }
            }
        }
        if (viewId == null) {
            Map m = (Map)this.mPortletContext.getAttribute("javax.portlet.faces." + this.mPortletName + "." + "defaultViewIdMap");
            viewId = (String)m.get(requestedMode);
            if (viewId == null) {
                throw new BridgeDefaultViewNotSpecifiedException();
            }
            this.log("PortletExternalContextImpl.getViewId: jsf target viewId not found, defaulting to: " + viewId);
        }
        int queryStart = viewId.indexOf(63);
        QueryString queryStr = null;
        if (queryStart != -1) {
            queryStr = new QueryString(viewId.substring(queryStart + 1), "UTF8");
            this.mTempExtraRequestParameterMap = new HashMap<String, String>(5);
            this.mTempExtraRequestParameterValuesMap = new HashMap<String, String[]>(5);
            this.mRequestParameterMap = null;
            this.mRequestParameterValuesMap = null;
            Enumeration<String> list = queryStr.getParameterNames();
            while (list.hasMoreElements()) {
                String param = list.nextElement();
                this.mTempExtraRequestParameterMap.put(param, queryStr.getParameter(param));
                Enumeration<String> e = queryStr.getParameterValues(param);
                ArrayList<String> l = new ArrayList<String>(5);
                while (e.hasMoreElements()) {
                    l.add(e.nextElement());
                }
                String[] values = new String[l.size()];
                this.mTempExtraRequestParameterValuesMap.put(param, l.toArray(values));
            }
            viewId = viewId.substring(0, queryStart);
            this.log("PortletExternalContextImpl.getViewId: special viewId: " + viewId);
        }
        if (updateHistory && this.getPortletPhase() == Bridge.PortletPhase.RENDER_PHASE) {
            this.updateViewChainAttribute(this.mPortletRequest.getPortletMode().toString(), viewId, modeChanged);
        }
        this.getRequestMap().put(NO_SCOPE, modeChanged);
        return viewId;
    }

    private void updateViewChainAttribute(String mode, String viewId, boolean modeChanged) {
        Map<String, String[]> m;
        QueryString qs = new QueryString("UTF8");
        qs.setParameter("javax.portlet.faces.PortletMode", mode);
        if (!modeChanged && !(m = this.getRequestParameterValuesMap()).isEmpty()) {
            Set<Map.Entry<String, String[]>> set = m.entrySet();
            for (Map.Entry<String, String[]> e : set) {
                if (e.getKey().equals(JSF_TARGET_VIEWID_RENDER_PARAMETER) || e.getKey().equals("javax.faces.ViewState")) continue;
                for (String s : e.getValue()) {
                    qs.addParameter(e.getKey(), s);
                }
            }
        }
        String toAppend = qs.toString();
        StringBuffer sb = new StringBuffer(viewId.length() + toAppend.length() + 1);
        viewId = sb.append(viewId).append("?").append(toAppend).toString();
        Map<String, Object> sessionMap = this.getSessionMap();
        StringBuffer key = new StringBuffer(100);
        sessionMap.put(key.append("javax.portlet.faces.viewIdHistory").append('.').append(mode).toString(), viewId);
        this.log("History for mode: " + mode + " : " + viewId);
    }

    private String replaceResourceQueryStringMarkers(String s) {
        String path = null;
        QueryString queryStr = null;
        int queryStart = -1;
        queryStart = s.indexOf(63);
        if (queryStart == -1) {
            return s;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        queryStr = new QueryString(s.substring(queryStart + 1), "UTF8");
        path = s.substring(0, queryStart);
        try {
            String backLinkValue = queryStr.removeParameter("javax.portlet.faces.BackLink");
            if (backLinkValue != null) {
                queryStr.setParameter(backLinkValue, this.encodeActionURL(context.getApplication().getViewHandler().getActionURL(context, context.getViewRoot().getViewId())), false);
            }
            queryStr.removeParameter("javax.portlet.faces.ViewLink");
        }
        catch (Exception e) {
            // empty catch block
        }
        String qs = queryStr.toString();
        s = qs.length() > 0 ? path + "?" + qs : path;
        return s;
    }

    private void mapPathsFromViewId(String viewId, List<String> mappings) {
        if (viewId == null || mappings == null) {
            this.mPathInfo = viewId;
            return;
        }
        String mapping = mappings.get(0);
        if (mapping.startsWith("*")) {
            this.mServletPath = viewId = viewId.substring(0, viewId.lastIndexOf(46)) + mapping.substring(mapping.indexOf(46));
            this.mPathInfo = null;
            if (this.mUseIncludeAttributeServletDependencyWorkaround) {
                this.mPortletRequest.setAttribute(SERVLET_INCLUDED_SERVLETPATH_ATTRIBUTE, (Object)this.mServletPath);
            }
        } else {
            int j = mapping.lastIndexOf("/*");
            this.mServletPath = j != -1 ? mapping.substring(0, j) : mapping;
            this.mPathInfo = viewId;
        }
    }

    private String extensionMappingFromViewId(String viewId) {
        int extLoc;
        int i = viewId.indexOf(63);
        if (i != -1) {
            viewId = viewId.substring(0, i);
        }
        if ((extLoc = viewId.lastIndexOf(46)) != -1 && extLoc > viewId.lastIndexOf(47)) {
            StringBuilder sb = new StringBuilder("*");
            sb.append(viewId.substring(extLoc));
            return sb.toString();
        }
        return null;
    }

    private String getViewIdFromPath(String url) {
        String ctxPath;
        int i = url.indexOf("?");
        if (i != -1) {
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(ctxPath = this.getRequestContextPath())) != -1) {
            url = url.substring(i + ctxPath.length());
        }
        String viewId = null;
        viewId = this.isSuffixedMapped(url, this.mFacesMappings) ? this.viewIdFromSuffixMapping(url, this.mFacesMappings, this.mPortletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX")) : (this.isPrefixedMapped(url, this.mFacesMappings) ? this.viewIdFromPrefixMapping(url, this.mFacesMappings) : null);
        return viewId;
    }

    private boolean isSuffixedMapped(String url, List<String> mappings) {
        String ext = this.extensionMappingFromViewId(url);
        return ext != null && mappings.contains(ext);
    }

    private String viewIdFromSuffixMapping(String url, List<String> mappings, String ctxDefault) {
        if (ctxDefault == null) {
            ctxDefault = ".jsp";
        }
        int i = url.lastIndexOf(".");
        if (ctxDefault != null && i != -1) {
            url = ctxDefault.startsWith(".") ? url.substring(0, i) + ctxDefault : url.substring(0, i) + "." + ctxDefault;
        }
        return url;
    }

    private boolean isPrefixedMapped(String url, List<String> mappings) {
        for (int i = 0; i < mappings.size(); ++i) {
            int j;
            String prefix = null;
            String mapping = mappings.get(i);
            if (mapping.startsWith("/") && (j = mapping.lastIndexOf("/*")) != -1) {
                prefix = mapping.substring(0, j);
            }
            if (prefix == null || !url.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void determineView(boolean updateHistory) {
        String viewId = this.getViewId(updateHistory);
        if (this.mViewId != null && viewId.equals(this.mViewId)) {
            return;
        }
        this.mViewId = viewId;
        this.mapPathsFromViewId(this.mViewId, this.mFacesMappings);
        this.setFacesMapping();
    }

    private String viewIdFromPrefixMapping(String url, List<String> mappings) {
        for (int i = 0; i < mappings.size(); ++i) {
            int j;
            String prefix = null;
            String mapping = mappings.get(i);
            if (mapping.startsWith("/") && (j = mapping.lastIndexOf("/*")) != -1) {
                prefix = mapping.substring(0, j);
            }
            if (prefix == null || !url.startsWith(prefix)) continue;
            return url.substring(prefix.length());
        }
        return null;
    }

    private void setFacesMapping() {
        String mapping = null;
        String servletPath = this.getRequestServletPath();
        mapping = this.getRequestPathInfo() == null ? servletPath.substring(servletPath.lastIndexOf(46)) : servletPath;
        this.getRequestMap().put("com.sun.faces.INVOCATION_PATH", mapping);
    }

    private boolean isPortletURL(String url) {
        return url.toLowerCase().startsWith("portlet:");
    }

    private String xhtmlEncode(String url) {
        StringBuffer sb = new StringBuffer(url.length());
        int copyFrom = 0;
        int currentPos = url.indexOf(63);
        if (currentPos == -1) {
            return url;
        }
        while (true) {
            int ampPos = url.indexOf(38, currentPos);
            int xhtmlAmpPos = url.indexOf("&amp;", currentPos);
            if (ampPos == -1) {
                if (copyFrom < url.length()) {
                    sb.append(url, copyFrom, url.length());
                }
                return sb.toString();
            }
            if (ampPos != xhtmlAmpPos) {
                sb.append(url, copyFrom, ampPos);
                sb.append("&amp;");
                copyFrom = ampPos + 1;
            }
            currentPos = ampPos + 1;
        }
    }

    private boolean isStrictXhtmlEncoded(String url) {
        int currentPos = url.indexOf(63);
        if (currentPos == -1) {
            return false;
        }
        boolean isStrict = false;
        while (true) {
            int ampPos = url.indexOf(38, currentPos);
            int xhtmlAmpPos = url.indexOf("&amp;", currentPos);
            if (ampPos == -1) {
                return isStrict;
            }
            if (ampPos != xhtmlAmpPos) {
                return false;
            }
            isStrict = true;
            currentPos = ampPos + 1;
        }
    }

    private boolean isAbsoluteURL(String url) {
        if ((url = url.toLowerCase()).startsWith("http:") || url.startsWith("https:")) {
            return true;
        }
        int i = url.indexOf(":");
        if (i == -1) {
            return false;
        }
        String scheme = url.substring(0, i);
        if (scheme.indexOf(";") != -1) {
            return false;
        }
        if (scheme.indexOf("/") != -1) {
            return false;
        }
        if (scheme.indexOf("#") != -1) {
            return false;
        }
        if (scheme.indexOf("?") != -1) {
            return false;
        }
        return scheme.indexOf(" ") == -1;
    }

    private boolean isOpaqueURL(String url) {
        if (!this.isAbsoluteURL(url)) {
            return false;
        }
        return url.indexOf(58) != url.indexOf(47) - 1;
    }

    private boolean isExternalURL(String url) {
        if (!this.isAbsoluteURL(url)) {
            return false;
        }
        String ctxPath = this.getRequestContextPath();
        int i = url.indexOf(ctxPath);
        int j = url.indexOf("?");
        return i == -1 || j != -1 && i >= j;
    }

    private boolean isDirectLink(String url) {
        return this.isTokenLink("javax.portlet.faces.DirectLink", url);
    }

    private boolean isViewLink(String url) {
        return this.isTokenLink("javax.portlet.faces.ViewLink", url);
    }

    private boolean isTokenLink(String token, String url) {
        int queryStart = url.indexOf(63);
        QueryString queryStr = null;
        String tokenParam = null;
        if (queryStart != -1) {
            queryStr = new QueryString(url.substring(queryStart + 1), "UTF8");
            tokenParam = queryStr.getParameter(token);
            return Boolean.parseBoolean(tokenParam);
        }
        return false;
    }

    private String removeDirectLink(String url) {
        return this.removeTokenLink("javax.portlet.faces.DirectLink", url);
    }

    private String removeTokenLink(String token, String url) {
        int queryStart = url.indexOf(63);
        QueryString queryStr = null;
        if (queryStart != -1) {
            queryStr = new QueryString(url.substring(queryStart + 1), "UTF8");
            queryStr.removeParameter(token);
            String query = queryStr.toString();
            url = query != null && query.length() != 0 ? url.substring(0, queryStart + 1) + query : url.substring(0, queryStart);
        }
        return url;
    }

    private void encodeFacesActionTarget(QueryString queryStr, String target) {
        String mode = queryStr.getParameter("javax.portlet.faces.PortletMode");
        if (mode == null || !this.mPortletRequest.isPortletModeAllowed(new PortletMode(mode))) {
            mode = this.mPortletRequest.getPortletMode().toString();
        } else if (!mode.equalsIgnoreCase(this.mPortletRequest.getPortletMode().toString())) {
            this.getRequestMap().put(NO_SCOPE, Boolean.TRUE);
        }
        queryStr.setParameter(JSF_TARGET_VIEWID_RENDER_PARAMETER, new StringBuffer(100).append(mode).append(':').append(target).toString());
    }

    private void encodeNonFacesActionTarget(QueryString queryStr, String target) {
        this.getRequestMap().put(NO_SCOPE, Boolean.TRUE);
        queryStr.setParameter("_jsfBridgeNonFacesView", target);
    }

    private String getPathFromRelativePath(String url) {
        String prefixURL;
        String pathInfo = this.getRequestPathInfo();
        String servletPath = this.getRequestServletPath();
        String currentViewId = pathInfo;
        if (servletPath != null) {
            currentViewId = pathInfo != null ? servletPath + pathInfo : servletPath;
        }
        if ((prefixURL = currentViewId.substring(0, currentViewId.lastIndexOf(47))).length() != 0 && !prefixURL.startsWith("/")) {
            return null;
        }
        if (url.startsWith("./")) {
            url = url.substring(2);
        }
        while (url.startsWith("../") && prefixURL.length() != 0) {
            url = url.substring(3);
            prefixURL = prefixURL.substring(0, prefixURL.lastIndexOf(47));
        }
        return prefixURL + "/" + url;
    }

    private boolean isRelativePath(String url) {
        if (url.startsWith("/")) {
            return false;
        }
        if (url.startsWith(".")) {
            return true;
        }
        int i = url.indexOf("://");
        if (i == -1) {
            return true;
        }
        int j = url.indexOf(63);
        return j != -1 && j < i;
    }
}

