/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXCommand;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXNavigationLevel;
import org.apache.myfaces.trinidad.component.core.nav.CoreNavigationPane;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationPaneRenderer
extends XhtmlRenderer {
    private PropertyKey _hintKey;
    private PropertyKey _titleKey;
    private PropertyKey _disabledKey;
    private static final String _HINT_TABS = "tabs";
    private static final String _HINT_BAR = "bar";
    private static final String _HINT_LIST = "list";
    private static final String _HINT_BUTTONS = "buttons";
    private static final String _HINT_CHOICE = "choice";
    private static final String _HINT_DEFAULT = "tabs";
    private static final String _CHOICE_SELECT_ID_SUFFIX = "_af_choice_select";
    private static final String _GO_BUTTON_LABEL_KEY = "af_menuChoice.GO";
    private static final Object _EXTRA_SUBMIT_PARAMS_KEY = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(NavigationPaneRenderer.class);

    public NavigationPaneRenderer() {
        super(CoreNavigationPane.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._hintKey = type.findKey("hint");
        this._titleKey = type.findKey("title");
        this._disabledKey = type.findKey("disabled");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!PartialPageUtils.containsPprTargets(arc, component, this.getClientId(context, component))) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        this.renderAllAttributes(context, arc, bean, false);
        this._renderStyleAttributes(context, arc, bean);
        this.renderId(context, component);
        int renderedItemCount = this._getItemCount((UIXHierarchy)component);
        int renderedRowCount = ((UIXHierarchy)component).getRowCount();
        if (renderedItemCount > 0 || renderedRowCount > 0) {
            this.renderContent(context, arc, (UIXHierarchy)component, bean);
        }
        writer.endElement("div");
    }

    private UIComponent _getStamp(UIXHierarchy component) {
        UIComponent stamp = component.getFacet("nodeStamp");
        return stamp;
    }

    protected void renderContent(FacesContext context, RenderingContext arc, UIXHierarchy component, FacesBean bean) throws IOException {
        NavItemData navItemData = new NavItemData();
        ArrayList<UIComponent> nonNavItemList = new ArrayList<UIComponent>();
        String renderingHint = this._getHint(bean);
        UIComponent nodeStamp = this._getStamp(component);
        if (nodeStamp == null) {
            for (UIComponent child : component.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof UIXCommand) {
                    UIXCommand navItem = (UIXCommand)child;
                    this._collectNavItemData(navItemData, navItem, -1, component);
                    continue;
                }
                if (renderingHint == _HINT_BAR || renderingHint == _HINT_BUTTONS) {
                    navItemData.addItemData(null);
                    nonNavItemList.add(child);
                    continue;
                }
                _LOG.severe("ILLEGAL_COMPONENT_HIERARCHY_UIXCOMMAND_EXPECTED");
                return;
            }
        } else {
            if (!(nodeStamp instanceof UIXCommand)) {
                _LOG.severe("ILLEGAL_COMPONENT_HIERARCHY_UIXCOMMAND_EXPECTED");
                return;
            }
            UIXCommand navStamp = (UIXCommand)nodeStamp;
            Object oldPath = component.getRowKey();
            NavigationPaneRenderer._setStartDepthPath(component, ((UIXNavigationLevel)component).getLevel());
            int componentRowCount = component.getRowCount();
            if (componentRowCount != 0) {
                int startIndex = component.getFirst();
                int endIndex = TableUtils.getLast((CollectionComponent)component, (int)startIndex);
                for (int i = startIndex; i <= endIndex; ++i) {
                    component.setRowIndex(i);
                    if (!navStamp.isRendered()) continue;
                    this._collectNavItemData(navItemData, navStamp, i, component);
                }
            }
            component.setRowKey(oldPath);
        }
        int visibleItemCount = navItemData.getItemCount();
        if (visibleItemCount != 0) {
            ResponseWriter rw = context.getResponseWriter();
            boolean isRtl = arc.getLocaleContext().isRightToLeft();
            boolean isChoiceHint = _HINT_CHOICE.equals(renderingHint);
            String choiceSelectId = null;
            if (isChoiceHint) {
                choiceSelectId = this.getClientId(context, (UIComponent)component) + _CHOICE_SELECT_ID_SUFFIX;
                if (isRtl) {
                    this._renderChoiceButton(context, arc, rw, isRtl, choiceSelectId);
                } else {
                    this._renderChoiceLabel(context, arc, rw, isRtl, bean);
                }
                rw.startElement("select", null);
                rw.writeAttribute("id", (Object)choiceSelectId, null);
                if (!NavigationPaneRenderer.supportsScripting(arc)) {
                    rw.writeAttribute("name", (Object)choiceSelectId, null);
                }
                NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::choice-options");
                if (this.getDisabled(bean)) {
                    rw.writeAttribute("disabled", (Object)Boolean.TRUE, null);
                }
            }
            int lastRowIndex = visibleItemCount - 1;
            boolean previousActive = false;
            int nextActiveIndex = navItemData.getEffectiveActiveIndex() - 1;
            Object oldPath = component.getRowKey();
            NavigationPaneRenderer._setStartDepthPath(component, ((UIXNavigationLevel)component).getLevel());
            Iterator iter = nonNavItemList.iterator();
            for (int i = 0; i < visibleItemCount; ++i) {
                Map<String, Object> currentItemData = navItemData.getItemData(i);
                if (currentItemData != null) {
                    currentItemData.put("isFirst", i == 0);
                    currentItemData.put("isLast", i == lastRowIndex);
                    currentItemData.put("previousActive", previousActive);
                    currentItemData.put("nextActive", i == nextActiveIndex);
                    Integer rowIndex = (Integer)currentItemData.get("rowIndex");
                    if (rowIndex != null) {
                        component.setRowIndex(rowIndex.intValue());
                    }
                    this._renderNavigationItem(context, arc, rw, currentItemData, renderingHint, isRtl);
                    previousActive = this.getBooleanFromProperty(currentItemData.get("isActive"));
                    continue;
                }
                this.renderNonCommandChild(i, context, arc, (UIComponent)iter.next(), i == lastRowIndex, renderingHint);
            }
            component.setRowKey(oldPath);
            if (isChoiceHint) {
                rw.endElement("select");
                if (isRtl) {
                    this._renderChoiceLabel(context, arc, rw, isRtl, bean);
                }
                this._renderChoiceButton(context, arc, rw, isRtl, choiceSelectId);
            }
        }
    }

    protected boolean hasChildren(UIComponent component) {
        int childCount = component.getChildCount();
        return childCount > 0;
    }

    private void _renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String renderingHint = this._getHint(bean);
        if ("tabs".equals(renderingHint)) {
            this.renderStyleAttributes(context, arc, bean, "af|navigationPane::tabs");
        } else if (_HINT_BAR.equals(renderingHint)) {
            this.renderStyleAttributes(context, arc, bean, "af|navigationPane::bar");
        } else {
            this.renderStyleAttributes(context, arc, bean, "af|navigationPane");
        }
    }

    private String _getHint(FacesBean bean) {
        String renderingHint = NavigationPaneRenderer.toString((Object)bean.getProperty(this._hintKey));
        if (renderingHint == null) {
            renderingHint = "tabs";
        }
        return renderingHint;
    }

    protected String getTitle(FacesBean bean) {
        return NavigationPaneRenderer.toString((Object)bean.getProperty(this._titleKey));
    }

    protected boolean getDisabled(FacesBean bean) {
        Object o = bean.getProperty(this._disabledKey);
        if (o == null) {
            o = this._disabledKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    private void _renderCommandChildId(FacesContext context, UIXCommand component) throws IOException {
        String clientId = this.getClientId(context, (UIComponent)component);
        context.getResponseWriter().writeURIAttribute("id", (Object)clientId, "id");
        context.getResponseWriter().writeURIAttribute("name", (Object)clientId, "id");
    }

    private Object _getFocusRowKey(UIXHierarchy component) {
        return component.getFocusRowKey();
    }

    private int _getItemCount(UIXHierarchy component) {
        Object focusPath = this._getFocusRowKey(component);
        int kids = NavigationPaneRenderer.getRenderedChildCount((UIComponent)component);
        if (focusPath == null) {
            return kids;
        }
        return kids + component.getDepth(focusPath) + 1;
    }

    private void _collectNavItemData(NavItemData navItemData, UIXCommand commandChild, int rowIndex, UIXHierarchy component) {
        int itemDataIndex = navItemData.getItemCount();
        boolean isActive = rowIndex >= 0 ? NavigationPaneRenderer._isOnFocusPath(component) : this.getBooleanFromProperty(this._getCommandChildProperty(commandChild, "selected"));
        if (isActive) {
            if (navItemData.getEffectiveActiveIndex() == -1) {
                navItemData.setEffectiveActiveIndex(itemDataIndex);
            } else {
                isActive = false;
            }
        }
        HashMap<String, Object> itemDataMap = new HashMap<String, Object>();
        itemDataMap.put("accessKey", this._getCommandChildProperty(commandChild, "accessKey"));
        itemDataMap.put("component", commandChild);
        itemDataMap.put("dataIndex", itemDataIndex);
        itemDataMap.put("destination", this._getCommandChildProperty(commandChild, "destination"));
        itemDataMap.put("icon", this._getCommandChildProperty(commandChild, "icon"));
        itemDataMap.put("immediate", this._getCommandChildProperty(commandChild, "immediate"));
        itemDataMap.put("inlineStyle", this._getCommandChildProperty(commandChild, "inlineStyle"));
        itemDataMap.put("isActive", isActive);
        itemDataMap.put("isDisabled", this._getCommandChildProperty(commandChild, "disabled"));
        itemDataMap.put("partialSubmit", this._getCommandChildProperty(commandChild, "partialSubmit"));
        itemDataMap.put("shortDesc", this._getCommandChildProperty(commandChild, "shortDesc"));
        itemDataMap.put("styleClass", this._getCommandChildProperty(commandChild, "styleClass"));
        itemDataMap.put("targetFrame", this._getCommandChildProperty(commandChild, "targetFrame"));
        itemDataMap.put("text", this._getCommandChildProperty(commandChild, "text"));
        if (rowIndex >= 0) {
            itemDataMap.put("rowIndex", rowIndex);
        }
        navItemData.addItemData(itemDataMap);
    }

    protected boolean getBooleanFromProperty(Object value) {
        if (value == null) {
            return false;
        }
        return "true".equals(value.toString());
    }

    private Object _getCommandChildProperty(UIXCommand commandChild, String propertyName) {
        FacesBean childFacesBean = commandChild.getFacesBean();
        FacesBean.Type type = childFacesBean.getType();
        PropertyKey propertyKey = type.findKey(propertyName);
        if (propertyKey == null) {
            if (_LOG.isSevere()) {
                _LOG.severe("NAVIGATIONLEVELRENDERER_NOT_FOUND_CHILD_PROPERTY", (Object)propertyName);
            }
            return null;
        }
        return childFacesBean.getProperty(propertyKey);
    }

    private void _renderNavigationItem(FacesContext context, RenderingContext arc, ResponseWriter rw, Map<String, Object> itemData, String renderingHint, boolean isRtl) throws IOException {
        if (_HINT_BAR.equals(renderingHint)) {
            this.renderNonOverlappingItem(context, arc, rw, itemData, isRtl, true, false);
        } else if (_HINT_BUTTONS.equals(renderingHint)) {
            this.renderNonOverlappingItem(context, arc, rw, itemData, isRtl, false, false);
        } else if (_HINT_CHOICE.equals(renderingHint)) {
            this._renderChoiceItem(context, arc, rw, itemData);
        } else if (_HINT_LIST.equals(renderingHint)) {
            this.renderNonOverlappingItem(context, arc, rw, itemData, isRtl, false, true);
        } else {
            this.renderTabItem(context, arc, rw, itemData, isRtl);
        }
    }

    protected void writeInlineStyles(ResponseWriter rw, Object userInlineStyle, String appendedInlineStyle) throws IOException {
        if (userInlineStyle == null) {
            rw.writeAttribute("style", (Object)appendedInlineStyle, null);
        } else {
            String userInlineStyleString = NavigationPaneRenderer.toString((Object)userInlineStyle).trim();
            boolean needSemicolon = false;
            int lastIndex = userInlineStyleString.length() - 1;
            if (lastIndex > 0 && userInlineStyleString.charAt(lastIndex) != ';') {
                needSemicolon = true;
            }
            StringBuilder itemInlineStyle = new StringBuilder();
            itemInlineStyle.append(userInlineStyleString);
            if (needSemicolon) {
                itemInlineStyle.append(";");
            }
            if (appendedInlineStyle != null) {
                itemInlineStyle.append(appendedInlineStyle);
            }
            rw.writeAttribute("style", (Object)itemInlineStyle.toString(), null);
        }
    }

    private void _writeInlineTbodyStyles(RenderingContext arc, ResponseWriter rw) throws IOException {
        if (arc.getAgent().getAgentName() == "gecko") {
            rw.writeAttribute("style", (Object)"display: inline;", null);
        }
    }

    protected void appendIconAndText(FacesContext context, RenderingContext arc, ResponseWriter rw, String iconUri, Map<String, Object> itemData, boolean isDisabled, boolean isRtl) throws IOException {
        if (iconUri != null && !isRtl) {
            this._appendIcon(context, rw, iconUri, isRtl, arc);
        }
        this._writeItemLink(context, arc, rw, itemData, isDisabled);
        if (iconUri != null && isRtl) {
            this._appendIcon(context, rw, iconUri, isRtl, arc);
        }
    }

    private void _appendIcon(FacesContext context, ResponseWriter rw, String iconUri, boolean isRtl, RenderingContext arc) throws IOException {
        String styleAppender = "";
        rw.startElement("img", null);
        rw.writeAttribute("border", (Object)"0", null);
        rw.writeAttribute("align", (Object)"absmiddle", null);
        if (NavigationPaneRenderer.isPDA((RenderingContext)arc)) {
            if (isRtl) {
                rw.writeAttribute("style", (Object)"padding-left: 5px;", null);
            } else {
                rw.writeAttribute("style", (Object)"padding-right: 5px;", null);
            }
        } else if (isRtl) {
            rw.writeAttribute("style", (Object)"padding-left: 5px; float: right;", null);
        } else {
            rw.writeAttribute("style", (Object)"padding-right: 5px; float: left;", null);
        }
        Application application = context.getApplication();
        ViewHandler handler = application.getViewHandler();
        String resolvedIconUri = handler.getResourceURL(context, iconUri);
        this.renderEncodedResourceURI(context, "src", resolvedIconUri);
        rw.endElement("img");
    }

    private void _renderCommandChildren(FacesContext context, UIXCommand uiComp) throws IOException {
        for (UIComponent child : uiComp.getChildren()) {
            RenderUtils.encodeRecursive((FacesContext)context, (UIComponent)child);
        }
    }

    private void _renderText(ResponseWriter rw, Map<String, Object> itemData) throws IOException {
        String text = NavigationPaneRenderer.toString((Object)itemData.get("text"));
        if (text != null) {
            rw.write(text);
        }
    }

    private void _writeItemLink(FacesContext context, RenderingContext arc, ResponseWriter rw, Map<String, Object> itemData, boolean isDisabled) throws IOException {
        boolean nonJavaScriptSubmit;
        UIXCommand commandChild = (UIXCommand)itemData.get("component");
        if (isDisabled) {
            this._renderText(rw, itemData);
            this._renderCommandChildren(context, commandChild);
            return;
        }
        String destination = NavigationPaneRenderer.toResourceUri((FacesContext)context, (Object)itemData.get("destination"));
        boolean immediate = false;
        boolean partialSubmit = false;
        if (destination == null) {
            immediate = this.getBooleanFromProperty(itemData.get("immediate"));
            partialSubmit = this.getBooleanFromProperty(itemData.get("partialSubmit"));
            if (partialSubmit) {
                AutoSubmitUtils.writeDependencies(context, arc);
            }
            String clientId = commandChild.getClientId(context);
            assert (arc.getCurrentClientId() == null);
            arc.setCurrentClientId(clientId);
            String extraParams = AutoSubmitUtils.getParameters((UIComponent)commandChild);
            arc.getProperties().put(_EXTRA_SUBMIT_PARAMS_KEY, extraParams);
        }
        boolean isActive = this.getBooleanFromProperty(itemData.get("isActive"));
        boolean isDesktop = arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
        boolean bl = nonJavaScriptSubmit = !NavigationPaneRenderer.supportsScripting(arc) && destination == null;
        if (nonJavaScriptSubmit) {
            rw.startElement("input", (UIComponent)commandChild);
            rw.writeAttribute("type", (Object)"submit", null);
            rw.writeAttribute("value", (Object)NavigationPaneRenderer.toString((Object)itemData.get("text")), "text");
            String clientId = this.getClientId(context, (UIComponent)commandChild);
            rw.writeAttribute("id", (Object)clientId, "id");
            rw.writeAttribute("name", (Object)(XhtmlUtils.getEncodedParameter("source") + clientId), null);
            String linkConverter = "border:none;background:inherit;text-decoration:underline;";
            if (isActive && !isDesktop) {
                linkConverter = linkConverter + "font-weight: bold;";
            }
            this.writeInlineStyles(rw, null, linkConverter);
        } else {
            rw.startElement("a", (UIComponent)commandChild);
            if (isActive && !isDesktop) {
                this.writeInlineStyles(rw, null, "font-weight: bold;");
            }
            this._renderCommandChildId(context, commandChild);
            if (destination == null) {
                rw.writeURIAttribute("href", (Object)"#", null);
            } else {
                this.renderEncodedActionURI(context, "href", destination);
                String targetFrame = NavigationPaneRenderer.toString((Object)itemData.get("targetFrame"));
                if (targetFrame != null && !Boolean.FALSE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_TARGET))) {
                    rw.writeAttribute("target", (Object)targetFrame, null);
                }
            }
            if (NavigationPaneRenderer.supportsScripting(arc)) {
                this._writeOnclickProperty(arc, rw, commandChild, destination == null, immediate, partialSubmit);
                this._writeCommandChildProperty(rw, commandChild, "ondblclick");
                this._writeCommandChildProperty(rw, commandChild, "onkeydown");
                this._writeCommandChildProperty(rw, commandChild, "onkeyup");
                this._writeCommandChildProperty(rw, commandChild, "onkeypress");
                this._writeCommandChildProperty(rw, commandChild, "onmousedown");
                this._writeCommandChildProperty(rw, commandChild, "onmousemove");
                this._writeCommandChildProperty(rw, commandChild, "onmouseout");
                this._writeCommandChildProperty(rw, commandChild, "onmouseover");
                this._writeCommandChildProperty(rw, commandChild, "onmouseup");
            }
        }
        String accessKey = NavigationPaneRenderer.toString((Object)itemData.get("accessKey"));
        if (!isDisabled && accessKey != null) {
            rw.writeAttribute("accessKey", (Object)accessKey, null);
        }
        if (nonJavaScriptSubmit) {
            this._renderCommandChildren(context, commandChild);
            rw.endElement("input");
        } else {
            this._renderText(rw, itemData);
            this._renderCommandChildren(context, commandChild);
            rw.endElement("a");
        }
        if (destination == null) {
            arc.setCurrentClientId(null);
            arc.getProperties().remove(_EXTRA_SUBMIT_PARAMS_KEY);
        }
    }

    private void _writeCommandChildProperty(ResponseWriter rw, UIXCommand commandChild, String propertyName) throws IOException {
        rw.writeAttribute(propertyName, this._getCommandChildProperty(commandChild, propertyName), propertyName);
    }

    private void _writeOnclickProperty(RenderingContext arc, ResponseWriter rw, UIXCommand commandChild, boolean actionSpecialCase, boolean immediate, boolean partialSubmit) throws IOException {
        if (actionSpecialCase) {
            String onclick = (String)this._getCommandChildProperty(commandChild, "onclick");
            String script = this._getAutoSubmitScript(arc, immediate, partialSubmit);
            rw.writeAttribute("onclick", (Object)XhtmlUtils.getChainedJS(onclick, script, true), "onclick");
        } else {
            this._writeCommandChildProperty(rw, commandChild, "onclick");
        }
    }

    private String _getAutoSubmitScript(RenderingContext arc, boolean immediate, boolean partialSubmit) {
        String id = arc.getCurrentClientId();
        String extraParams = (String)arc.getProperties().get(_EXTRA_SUBMIT_PARAMS_KEY);
        String script = partialSubmit ? AutoSubmitUtils.getSubmitScript(arc, id, immediate, false, null, extraParams, false) : AutoSubmitUtils.getFullPageSubmitScript(arc, id, immediate, null, extraParams, false);
        return script;
    }

    protected void renderNonOverlappingItem(FacesContext context, RenderingContext arc, ResponseWriter rw, Map<String, Object> itemData, boolean isRtl, boolean isBar, boolean isList) throws IOException {
        rw.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        String appendedStyle = null;
        if (!isList) {
            appendedStyle = "display: inline;";
            if (arc.getAgent().getAgentName() == "webkit") {
                appendedStyle = "display: inline-block;";
            }
        }
        this.writeInlineStyles(rw, NavigationPaneRenderer.toString((Object)itemData.get("inlineStyle")), appendedStyle);
        rw.writeAttribute("title", itemData.get("shortDesc"), null);
        StringBuilder itemStyleClass = new StringBuilder();
        String userStyleClass = NavigationPaneRenderer.toString((Object)itemData.get("styleClass"));
        if (userStyleClass != null) {
            itemStyleClass.append(userStyleClass);
            itemStyleClass.append(" ");
        }
        boolean isDisabled = this.getBooleanFromProperty(itemData.get("isDisabled"));
        boolean isActive = this.getBooleanFromProperty(itemData.get("isActive"));
        if (isActive) {
            if (isDisabled) {
                if (isList) {
                    itemStyleClass.append("af|navigationPane::list-active-disabled");
                } else if (isBar) {
                    itemStyleClass.append("af|navigationPane::bar-active-disabled");
                } else {
                    itemStyleClass.append("af|navigationPane::buttons-active-disabled");
                }
            } else if (isList) {
                itemStyleClass.append("af|navigationPane::list-active-enabled");
            } else if (isBar) {
                itemStyleClass.append("af|navigationPane::bar-active-enabled");
            } else {
                itemStyleClass.append("af|navigationPane::buttons-active-enabled");
            }
        } else if (isDisabled) {
            if (isList) {
                itemStyleClass.append("af|navigationPane::list-inactive-disabled");
            } else if (isBar) {
                itemStyleClass.append("af|navigationPane::bar-inactive-disabled");
            } else {
                itemStyleClass.append("af|navigationPane::buttons-inactive-disabled");
            }
        } else if (isList) {
            itemStyleClass.append("af|navigationPane::list-inactive-enabled");
        } else if (isBar) {
            itemStyleClass.append("af|navigationPane::bar-inactive-enabled");
        } else {
            itemStyleClass.append("af|navigationPane::buttons-inactive-enabled");
        }
        NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)itemStyleClass.toString());
        rw.startElement("tbody", null);
        if (!isList) {
            this._writeInlineTbodyStyles(arc, rw);
        }
        rw.startElement("tr", null);
        if (isList) {
            rw.startElement("td", null);
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::list-bullet");
            rw.startElement("div", null);
            rw.write(" ");
            rw.endElement("div");
            rw.endElement("td");
        }
        rw.startElement("td", null);
        rw.startElement("div", null);
        if (isList) {
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::list-content");
        } else if (isBar) {
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::bar-content");
        } else {
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::buttons-content");
        }
        this.appendIconAndText(context, arc, rw, NavigationPaneRenderer.toString((Object)itemData.get("icon")), itemData, isDisabled, isRtl);
        rw.endElement("div");
        rw.endElement("td");
        if (!isList && !this.getBooleanFromProperty(itemData.get("isLast"))) {
            rw.startElement("td", null);
            rw.startElement("div", null);
            if (isBar) {
                NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::bar-separator");
            } else {
                NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::buttons-separator");
            }
            rw.write("|");
            rw.endElement("div");
            rw.endElement("td");
        }
        rw.endElement("tr");
        rw.endElement("tbody");
        rw.endElement("table");
    }

    protected void renderNonCommandChild(int index, FacesContext context, RenderingContext arc, UIComponent child, boolean isLastItem, String hint) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        String appendedStyle = null;
        appendedStyle = "display: inline;";
        if (arc.getAgent().getAgentName() == "webkit") {
            appendedStyle = "display: inline-block;";
        }
        this.writeInlineStyles(rw, null, appendedStyle);
        rw.startElement("tbody", null);
        this._writeInlineTbodyStyles(arc, rw);
        rw.startElement("tr", null);
        rw.startElement("td", null);
        rw.startElement("div", null);
        this.encodeChild(context, child);
        rw.endElement("div");
        rw.endElement("td");
        if (!isLastItem) {
            rw.startElement("td", null);
            rw.startElement("div", null);
            if (hint == _HINT_BAR) {
                NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::bar-separator");
            } else {
                NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::buttons-separator");
            }
            rw.write("|");
            rw.endElement("div");
            rw.endElement("td");
        }
        rw.endElement("tr");
        rw.endElement("tbody");
        rw.endElement("table");
    }

    private void _renderChoiceItem(FacesContext context, RenderingContext arc, ResponseWriter rw, Map<String, Object> itemData) throws IOException {
        boolean isDisabled = this.getBooleanFromProperty(itemData.get("isDisabled"));
        if (!isDisabled || Boolean.TRUE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_SUPPORTS_DISABLED_OPTIONS))) {
            boolean isActive = this.getBooleanFromProperty(itemData.get("isActive"));
            UIXCommand commandChild = null;
            String destination = null;
            boolean partialSubmit = false;
            if (!isDisabled) {
                commandChild = (UIXCommand)itemData.get("component");
                destination = NavigationPaneRenderer.toString((Object)itemData.get("destination"));
                if (destination == null && (partialSubmit = this.getBooleanFromProperty(itemData.get("partialSubmit")))) {
                    AutoSubmitUtils.writeDependencies(context, arc);
                }
            }
            rw.startElement("option", null);
            if (isActive) {
                rw.writeAttribute("selected", (Object)Boolean.TRUE, null);
            }
            rw.writeAttribute("disabled", (Object)isDisabled, null);
            rw.writeAttribute("title", itemData.get("shortDesc"), null);
            if (!isDisabled) {
                String selectionScript;
                boolean immediate = false;
                if (destination == null) {
                    immediate = this.getBooleanFromProperty(itemData.get("immediate"));
                    String clientId = commandChild.getClientId(context);
                    assert (arc.getCurrentClientId() == null);
                    arc.setCurrentClientId(clientId);
                    String extraParams = AutoSubmitUtils.getParameters((UIComponent)commandChild);
                    arc.getProperties().put(_EXTRA_SUBMIT_PARAMS_KEY, extraParams);
                }
                this._renderCommandChildId(context, commandChild);
                if (!NavigationPaneRenderer.supportsScripting(arc)) {
                    selectionScript = arc.getCurrentClientId();
                } else if (destination == null) {
                    selectionScript = this._getAutoSubmitScript(arc, immediate, partialSubmit);
                    selectionScript = selectionScript.substring(0, selectionScript.length() - 13);
                } else {
                    String encodedDestination = context.getExternalContext().encodeActionURL(destination);
                    String targetFrame = NavigationPaneRenderer.toString((Object)itemData.get("targetFrame"));
                    StringBuilder sb = new StringBuilder();
                    if (targetFrame != null && !Boolean.FALSE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_TARGET))) {
                        sb.append("window.open('");
                        sb.append(encodedDestination);
                        sb.append("','");
                        sb.append(targetFrame);
                        sb.append("');");
                    } else {
                        sb.append("self.location='");
                        sb.append(encodedDestination);
                        sb.append("';");
                    }
                    selectionScript = sb.toString();
                }
                rw.writeAttribute("value", (Object)selectionScript, null);
                if (destination == null) {
                    arc.setCurrentClientId(null);
                    arc.getProperties().remove(_EXTRA_SUBMIT_PARAMS_KEY);
                }
            }
            this._renderText(rw, itemData);
            rw.endElement("option");
        }
    }

    private void _renderChoiceLabel(FacesContext context, RenderingContext arc, ResponseWriter rw, boolean isRtl, FacesBean bean) throws IOException {
        String chooseText = this.getTitle(bean);
        if (chooseText == null || chooseText.length() == 0) {
            chooseText = this.getShortDesc(bean);
        }
        if (chooseText != null && chooseText.length() != 0) {
            if (isRtl) {
                this._renderSpace(rw);
            }
            rw.startElement("span", null);
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::choice-label");
            rw.write(chooseText);
            rw.endElement("span");
            if (!isRtl) {
                this._renderSpace(rw);
            }
        }
    }

    private void _renderChoiceButton(FacesContext context, RenderingContext arc, ResponseWriter rw, boolean isRtl, String choiceSelectId) throws IOException {
        boolean useButtonTag;
        if (!isRtl) {
            this._renderSpace(rw);
        }
        String element = (useButtonTag = NavigationPaneRenderer.supportsAdvancedForms(arc)) ? "button" : "input";
        rw.startElement(element, null);
        NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|navigationPane::choice-button");
        String goText = arc.getSkin().getTranslatedString(arc.getLocaleContext(), _GO_BUTTON_LABEL_KEY);
        rw.writeAttribute("type", (Object)(useButtonTag ? "button" : "submit"), null);
        if (!NavigationPaneRenderer.supportsScripting(arc)) {
            String nameAttri = XhtmlUtils.getEncodedParameter("multipleValueParam") + choiceSelectId;
            rw.writeAttribute("name", (Object)nameAttri, null);
        } else {
            rw.writeAttribute("onclick", (Object)("var navLevelSelect = document.getElementById('" + choiceSelectId + "'); eval(navLevelSelect.options[navLevelSelect.selectedIndex].value); return false;"), null);
        }
        if (useButtonTag) {
            rw.write(goText);
        } else {
            rw.writeAttribute("value", (Object)goText, "text");
        }
        rw.endElement(element);
        if (isRtl) {
            this._renderSpace(rw);
        }
    }

    private void _renderSpace(ResponseWriter rw) throws IOException {
        rw.startElement("span", null);
        rw.writeAttribute("style", (Object)"width: 5px;", null);
        rw.write(" ");
        rw.endElement("span");
    }

    protected void renderTabItem(FacesContext context, RenderingContext arc, ResponseWriter rw, Map<String, Object> itemData, boolean isRtl) throws IOException {
        String sectionStyleClass1;
        rw.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        String appendedStyle = "display: inline;";
        if (arc.getAgent().getAgentName() == "webkit") {
            appendedStyle = "display: inline-block;";
        }
        this.writeInlineStyles(rw, NavigationPaneRenderer.toString((Object)itemData.get("inlineStyle")), appendedStyle);
        rw.writeAttribute("title", itemData.get("shortDesc"), null);
        StringBuilder itemStyleClass = new StringBuilder();
        String userStyleClass = NavigationPaneRenderer.toString((Object)itemData.get("styleClass"));
        if (userStyleClass != null) {
            itemStyleClass.append(userStyleClass);
            itemStyleClass.append(" ");
        }
        boolean isDisabled = this.getBooleanFromProperty(itemData.get("isDisabled"));
        boolean isActive = this.getBooleanFromProperty(itemData.get("isActive"));
        String sectionStyleClass2 = null;
        if (isActive) {
            if (isDisabled) {
                sectionStyleClass2 = "p_AFDisabled";
            }
            sectionStyleClass1 = "af|navigationPane::tabs-active";
        } else {
            if (isDisabled) {
                sectionStyleClass2 = "p_AFDisabled";
            }
            sectionStyleClass1 = "af|navigationPane::tabs-inactive";
        }
        NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)itemStyleClass.toString());
        rw.startElement("tbody", null);
        this._writeInlineTbodyStyles(arc, rw);
        rw.startElement("tr", null);
        boolean isFirst = this.getBooleanFromProperty(itemData.get("isFirst"));
        boolean isLast = this.getBooleanFromProperty(itemData.get("isLast"));
        boolean previousActive = this.getBooleanFromProperty(itemData.get("previousActive"));
        if (isFirst) {
            rw.startElement("td", null);
            this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-start", "af|navigationPane::tabs-bottom-start", "af|navigationPane::tabs-bottom-start-content", null, isDisabled, isRtl);
            rw.endElement("td");
        } else if (previousActive) {
            rw.startElement("td", null);
            this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-start-join-from-active", "af|navigationPane::tabs-bottom-end", "af|navigationPane::tabs-bottom-mid-content", null, isDisabled, isRtl);
            rw.endElement("td");
        } else if (isActive) {
            rw.startElement("td", null);
            this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-start-join", "af|navigationPane::tabs-bottom-start", "af|navigationPane::tabs-bottom-start-content", null, isDisabled, isRtl);
            rw.endElement("td");
        } else {
            rw.startElement("td", null);
            this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-start-join-from-inactive", "af|navigationPane::tabs-bottom-end", "af|navigationPane::tabs-bottom-mid-content", null, isDisabled, isRtl);
            rw.endElement("td");
        }
        rw.startElement("td", null);
        this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-mid", "af|navigationPane::tabs-bottom-mid", "af|navigationPane::tabs-bottom-mid-content", itemData, isDisabled, isRtl);
        rw.endElement("td");
        if (isLast) {
            rw.startElement("td", null);
            this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-end", "af|navigationPane::tabs-bottom-end", "af|navigationPane::tabs-bottom-end-content", null, isDisabled, isRtl);
            rw.endElement("td");
        } else if (isActive || !this.getBooleanFromProperty(itemData.get("nextActive"))) {
            rw.startElement("td", null);
            this._renderTabSection(context, arc, rw, sectionStyleClass1, sectionStyleClass2, "af|navigationPane::tabs-end-join-to-inactive", "af|navigationPane::tabs-bottom-end-join", "af|navigationPane::tabs-bottom-end-content", null, isDisabled, isRtl);
            rw.endElement("td");
        }
        rw.endElement("tr");
        rw.endElement("tbody");
        rw.endElement("table");
    }

    private void _renderTabSection(FacesContext context, RenderingContext arc, ResponseWriter rw, String sectionStyleClass1, String sectionStyleClass2, String topStyleClass, String bottomStyleClass, String bottomContentStyleClass, Map<String, Object> itemData, boolean isDisabled, boolean isRtl) throws IOException {
        rw.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        if (sectionStyleClass2 == null) {
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)sectionStyleClass1);
        } else {
            String[] sectionStyleClasses = new String[]{sectionStyleClass1, sectionStyleClass2};
            NavigationPaneRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])sectionStyleClasses);
        }
        rw.startElement("tbody", null);
        rw.startElement("tr", null);
        rw.startElement("td", null);
        NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)topStyleClass);
        if (itemData != null) {
            this.appendIconAndText(context, arc, rw, NavigationPaneRenderer.toString((Object)itemData.get("icon")), itemData, isDisabled, isRtl);
        }
        rw.endElement("td");
        rw.endElement("tr");
        rw.startElement("tr", null);
        rw.startElement("td", null);
        NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)bottomStyleClass);
        if (bottomContentStyleClass != null) {
            rw.startElement("div", null);
            NavigationPaneRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)bottomContentStyleClass);
            rw.endElement("div");
        }
        rw.endElement("td");
        rw.endElement("tr");
        rw.endElement("tbody");
        rw.endElement("table");
    }

    private static boolean _setStartDepthPath(UIXHierarchy component, int startDepth) {
        boolean isNewPath = false;
        Object focusKey = component.getFocusRowKey();
        if (focusKey != null) {
            ArrayList<Object> focusPath = component.getAllAncestorContainerRowKeys(focusKey);
            focusPath = new ArrayList<Object>(focusPath);
            focusPath.add(focusKey);
            int focusSize = focusPath.size();
            if (focusSize > startDepth) {
                isNewPath = true;
                component.setRowKey(focusPath.get(startDepth));
            } else if (focusSize == startDepth) {
                isNewPath = true;
                component.setRowKey(focusKey);
                component.enterContainer();
            }
        } else if (startDepth == 0) {
            isNewPath = true;
            component.setRowKey(null);
        }
        return isNewPath;
    }

    private static boolean _isOnFocusPath(UIXHierarchy component) {
        boolean isOnFocusPath = false;
        Object focusKey = component.getFocusRowKey();
        Object currentRowKey = component.getRowKey();
        if (focusKey != null) {
            ArrayList<Object> focusPath = component.getAllAncestorContainerRowKeys(focusKey);
            focusPath = new ArrayList<Object>(focusPath);
            focusPath.add(focusKey);
            int focusSize = focusPath.size();
            for (int i = 0; i < focusSize; ++i) {
                Object rowKey = focusPath.get(i);
                if (!rowKey.equals(currentRowKey)) continue;
                isOnFocusPath = true;
                break;
            }
        }
        return isOnFocusPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NavItemData {
        private List<Map<String, Object>> _list = new ArrayList<Map<String, Object>>();
        private int _effectiveActiveIndex = -1;

        NavItemData() {
        }

        int getEffectiveActiveIndex() {
            return this._effectiveActiveIndex;
        }

        void setEffectiveActiveIndex(int effectiveActiveIndex) {
            this._effectiveActiveIndex = effectiveActiveIndex;
        }

        int getItemCount() {
            return this._list.size();
        }

        void addItemData(Map<String, Object> itemData) {
            this._list.add(itemData);
        }

        Map<String, Object> getItemData(int index) {
            return this._list.get(index);
        }
    }
}

