/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageRenderer;
import org.apache.myfaces.trinidadinternal.image.laf.browser.BlafImageUtils;
import org.apache.myfaces.trinidadinternal.image.laf.browser.MirrorImageFilter;
import org.apache.myfaces.trinidadinternal.image.laf.browser.SourceUtils;
import org.apache.myfaces.trinidadinternal.image.painter.ImageLoader;
import org.apache.myfaces.trinidadinternal.image.painter.ImageUtils;
import org.apache.myfaces.trinidadinternal.style.util.GraphicsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorizedIconImageRenderer
implements ImageRenderer {
    private static final int[] _SOURCE_COLORS = new int[]{13158, 0x336699, 0x6699CC, 0x99CCFF, 0x999966, 0xCCCC99, 0xFFFFCC, 0xF7F7E7};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColorizedIconImageRenderer.class);

    @Override
    public Image renderImage(ImageContext context, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
        if (!GraphicsUtils.isGraphicalEnvironment()) {
            return null;
        }
        Image icon = SourceUtils.getSourceIcon(context, requestedProperties);
        if (icon == null) {
            assert (false);
            return null;
        }
        int[] targetColors = ColorizedIconImageRenderer._getTargetColors(requestedProperties);
        ColorizingFilter filter = new ColorizingFilter(_SOURCE_COLORS, targetColors);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ImageProducer producer = icon.getSource();
        if (this._isRightToLeft(context)) {
            producer = new FilteredImageSource(producer, new MirrorImageFilter());
        }
        Image colorizedIcon = toolkit.createImage(new FilteredImageSource(producer, filter));
        ImageUtils.loadImage(colorizedIcon);
        ImageLoader loader = new ImageLoader(icon);
        int width = icon.getWidth(loader);
        int height = icon.getHeight(loader);
        if (width != -1) {
            responseProperties.put(ImageConstants.WIDTH_RESPONSE_KEY, width);
        }
        if (height != -1) {
            responseProperties.put(ImageConstants.HEIGHT_RESPONSE_KEY, height);
        }
        BufferedImage bufferedIcon = new BufferedImage(width, height, 6);
        Graphics g = bufferedIcon.getGraphics();
        Color surroundingColor = (Color)requestedProperties.get(ImageConstants.SURROUNDING_COLOR_KEY);
        if (surroundingColor != null) {
            g.setColor(surroundingColor);
            g.fillRect(0, 0, width, height);
        }
        g.drawImage(colorizedIcon, 0, 0, loader);
        icon.flush();
        colorizedIcon.flush();
        return bufferedIcon;
    }

    private boolean _isRightToLeft(ImageContext context) {
        return context.getLocaleContext().isRightToLeft();
    }

    private static int[] _getTargetColors(Map<Object, Object> properties) {
        Color darkColor = BlafImageUtils.__DARK_COLOR;
        Color darkAccentColor = BlafImageUtils.__DARK_ACCENT_COLOR;
        Color color = (Color)properties.get(ImageConstants.DARK_COLOR_KEY);
        if (color != null) {
            darkColor = color;
        }
        if ((color = (Color)properties.get(ImageConstants.DARK_ACCENT_COLOR_KEY)) != null) {
            darkAccentColor = color;
        }
        Color veryDarkColor = BlafImageUtils.__getDarkerColor(darkColor);
        Color mediumColor = BlafImageUtils.__getLighterColor(darkColor);
        Color lightColor = BlafImageUtils.__getLighterColor(mediumColor);
        Color veryDarkAccentColor = BlafImageUtils.__getDarkerColor(darkAccentColor);
        Color mediumAccentColor = BlafImageUtils.__getLighterColor(darkAccentColor);
        Color lightAccentColor = BlafImageUtils.__getDerivedColor(darkAccentColor, 37, 31, 55);
        int[] targetColors = new int[_SOURCE_COLORS.length];
        targetColors[0] = veryDarkColor.getRGB() & 0xFFFFFF;
        targetColors[1] = darkColor.getRGB() & 0xFFFFFF;
        targetColors[2] = mediumColor.getRGB() & 0xFFFFFF;
        targetColors[3] = lightColor.getRGB() & 0xFFFFFF;
        targetColors[4] = veryDarkAccentColor.getRGB() & 0xFFFFFF;
        targetColors[5] = darkAccentColor.getRGB() & 0xFFFFFF;
        targetColors[6] = mediumAccentColor.getRGB() & 0xFFFFFF;
        targetColors[7] = lightAccentColor.getRGB() & 0xFFFFFF;
        return targetColors;
    }

    private static class ColorizingFilter
    extends RGBImageFilter {
        private final int[] _sourceColors;
        private final int[] _targetColors;
        private int _last;
        private int _lastValue;

        public ColorizingFilter(int[] sourceColors, int[] targetColors) {
            if (sourceColors.length != targetColors.length) {
                throw new IllegalArgumentException(_LOG.getMessage("DIFFERENT_LENGTHS_SOURCECOLORS_TARGETCOLORS"));
            }
            this._sourceColors = new int[sourceColors.length];
            System.arraycopy(sourceColors, 0, this._sourceColors, 0, sourceColors.length);
            this._targetColors = new int[targetColors.length];
            System.arraycopy(targetColors, 0, this._targetColors, 0, targetColors.length);
            this.canFilterIndexColorModel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int filterRGB(int x, int y, int rgb) {
            ColorizingFilter colorizingFilter = this;
            synchronized (colorizingFilter) {
                if (this._last == rgb) {
                    return this._lastValue;
                }
            }
            int source = rgb & 0xFFFFFF;
            int alpha = rgb & 0xFF000000;
            for (int i = 0; i < this._sourceColors.length; ++i) {
                if (source != this._sourceColors[i]) continue;
                int target = this._targetColors[i] | alpha;
                if (this._last != rgb) {
                    ColorizingFilter colorizingFilter2 = this;
                    synchronized (colorizingFilter2) {
                        this._last = rgb;
                        this._lastValue = target;
                    }
                }
                return target;
            }
            return rgb;
        }
    }
}

