/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidadinternal.share.text.RGBColorFormat;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.expl.ColorPaletteUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ColorPaletteRenderer
extends HtmlLafRenderer {
    private static final String _CELL_SIZE = "11";
    private static final Object _SCRIPT_WRITTEN_KEY = new Object();
    private static final String _ON_CP_SEL_NS = "function _onCPSel(s,b,v) {var parser = new TrColorConverter(\"#RRGGBB\"); var color = (v != null) ? parser.getAsObject(v) : new TrColor(0,0,0,0); _handleClientEvent('colorSelect', s, {value:color}, b); }";
    private static final String _ON_CP_SEL_IE = "function _onCPSel(s,b) {var ele=window.event.srcElement;if (ele.tagName=='A') ele=ele.childNodes[0];  if (ele.tagName == 'IMG') {var parser = new TrColorConverter(\"#RRGGBB\"); var color = parser.getAsObject(ele.style.backgroundColor); if (color == null) { color = new TrColor(0,0,0,0) }; _handleClientEvent('colorSelect', s, {value:color}, b);}}";
    private static final String _ON_CP_SEL_MZ = "function _onCPSel(s,b,e) {var ele=e.target; if (ele.tagName=='A') ele=ele.childNodes[0]; if (ele.tagName == 'IMG') {var color = ele.style.backgroundColor;var parser = new TrColorConverter([\"'rgb'(r, g, b)\",\"'rgb'(r,g,b)\",\"#RRGGBB\"]); color = parser.getAsObject(color); if (color == null) { color = new TrColor(0,0,0,0) }; _handleClientEvent('colorSelect', s, {value:color}, b);}}";

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        super.prerender(context, node);
        BaseDesktopUtils.addLib(context, "TrColorConverter()");
    }

    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        List<Color> colorData = ColorPaletteRenderer._getColors(context, node, COLOR_DATA_ATTR);
        if (colorData == null) {
            colorData = ColorPaletteUtils.getColorPaletteMap().get("default49");
        }
        List<Color> customColorData = ColorPaletteRenderer._getColors(context, node, CUSTOM_COLOR_DATA_ATTR);
        int width = this.getWidth(context, node);
        int height = this.getHeight(context, node);
        if (colorData != null && !colorData.isEmpty()) {
            this._renderColorPalette(context, node, colorData, width, height);
        }
        if (customColorData != null && !customColorData.isEmpty()) {
            this.renderSpacer(context, -1, 8);
            this._renderColorPalette(context, node, customColorData, width, 0);
        }
    }

    private void _renderColorPalette(UIXRenderingContext context, UINode node, List<Color> colorData, int width, int height) throws IOException {
        int colorCount = colorData.size();
        if (colorCount > 0) {
            if (width <= 0 && height <= 0) {
                width = height = (int)Math.ceil(Math.sqrt(colorCount));
            } else if (width <= 0) {
                width = (int)Math.ceil((double)colorCount / (double)height);
            } else if (height <= 0) {
                height = (int)Math.ceil((double)colorCount / (double)width);
            }
        }
        assert (colorCount == 0 || width > 0 && height > 0);
        boolean isNetscape = ColorPaletteRenderer.isNetscape(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", null);
        ColorPaletteRenderer.renderLayoutTableAttributes(context, "0", "1", null);
        if (!isNetscape) {
            ColorPaletteRenderer.renderStyleClassAttribute(context, "p_OraColorPalette");
        } else {
            writer.startElement("tr", null);
            writer.startElement("td", null);
            ColorPaletteRenderer.renderStyleClassAttribute(context, "p_OraColorPalette");
            writer.startElement("table", null);
            ColorPaletteRenderer.renderLayoutTableAttributes(context, "0", "1", null);
        }
        Object onColorSelect = this.getOnColorSelect(context, node);
        boolean hasOnColorSelect = onColorSelect != null;
        boolean scriptWritten = Boolean.TRUE.equals(ColorPaletteRenderer.getRenderingProperty(context, _SCRIPT_WRITTEN_KEY));
        if (!scriptWritten) {
            ColorPaletteRenderer.setRenderingProperty(context, _SCRIPT_WRITTEN_KEY, Boolean.TRUE);
            writer.startElement("script", null);
            XhtmlLafRenderer.renderScriptDeferAttribute(context);
            XhtmlLafRenderer.renderScriptTypeAttribute(context);
            if (isNetscape) {
                writer.write(_ON_CP_SEL_NS);
            } else if (ColorPaletteRenderer.isIE(context)) {
                writer.write(_ON_CP_SEL_IE);
            } else {
                writer.write(_ON_CP_SEL_MZ);
            }
            writer.endElement("script");
        }
        StringBuilder onCellClick = null;
        int onCellClickLength = 0;
        if (isNetscape) {
            Object id = this.getID(context, node);
            if (id == null) {
                id = "null";
            }
            onCellClick = new StringBuilder(id.toString().length() + onColorSelect.toString().length() + 16);
            onCellClick.append("_onCPSel('");
            onCellClick.append(id);
            onCellClick.append("','");
            BaseDesktopUtils.escapeJS(onCellClick, onColorSelect.toString(), true);
            onCellClick.append('\'');
            onCellClickLength = onCellClick.toString().length();
        }
        String pattern = "#RRGGBB";
        for (int y = 0; y < height; ++y) {
            writer.startElement("tr", null);
            writer.writeAttribute("height", (Object)_CELL_SIZE, null);
            for (int x = 0; x < width; ++x) {
                int index = y * width + x;
                Color color = index < colorCount ? colorData.get(index) : null;
                writer.startElement("td", null);
                if (color != null) {
                    if (color.getAlpha() == 0) {
                        String destination = null;
                        String onClick = null;
                        if (hasOnColorSelect) {
                            destination = "#";
                            if (onCellClick != null) {
                                onCellClick.setLength(onCellClickLength);
                                onCellClick.append("); return false");
                                onClick = onCellClick.toString();
                            }
                        }
                        this.renderIcon(context, ColorPaletteRenderer.getBaseImageURI(context) + "cpt.gif", "af_chooseColor.TRANSPARENT", destination, null, onClick, null, null, true);
                    } else {
                        String colorString = CSSUtils.getColorValue(color);
                        if (isNetscape) {
                            writer.writeAttribute("bgcolor", (Object)colorString, null);
                        }
                        if (hasOnColorSelect) {
                            writer.startElement("a", null);
                            if (onCellClick != null) {
                                onCellClick.setLength(onCellClickLength);
                                onCellClick.append(",'");
                                onCellClick.append(colorString);
                                onCellClick.append("'); return false");
                                writer.writeAttribute("onclick", (Object)onCellClick.toString(), null);
                            }
                            writer.writeAttribute("href", (Object)"#", null);
                        }
                        writer.startElement("img", null);
                        writer.writeAttribute("border", (Object)"0", null);
                        writer.writeAttribute("width", (Object)_CELL_SIZE, null);
                        writer.writeAttribute("height", (Object)_CELL_SIZE, null);
                        if (!isNetscape) {
                            writer.writeAttribute("style", (Object)("background-color:" + colorString), null);
                            XhtmlLafRenderer.renderStyleClassAttribute(context, "p_OraDisplayBlock");
                        }
                        ColorPaletteRenderer.writeAbsoluteImageURI(context, "src", "t.gif");
                        ColorPaletteRenderer.renderAltAndTooltipForImage(context, new RGBColorFormat(pattern).format(color));
                        writer.endElement("img");
                        if (hasOnColorSelect) {
                            writer.endElement("a");
                        }
                    }
                } else {
                    ColorPaletteRenderer.renderStyleClassAttribute(context, "p_OraColorPaletteEmptyCell");
                    if (isNetscape) {
                        writer.startElement("img", null);
                        writer.writeAttribute("border", (Object)"0", null);
                        writer.writeAttribute("width", (Object)_CELL_SIZE, null);
                        writer.writeAttribute("height", (Object)_CELL_SIZE, null);
                        ColorPaletteRenderer.writeAbsoluteImageURI(context, "src", "t.gif");
                        writer.endElement("img");
                    } else {
                        writer.writeAttribute("width", (Object)_CELL_SIZE, null);
                    }
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        if (isNetscape) {
            writer.endElement("table");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return "span";
    }

    protected int getWidth(UIXRenderingContext context, UINode node) {
        return ColorPaletteRenderer.getIntAttributeValue(context, node, WIDTH_ATTR, 0);
    }

    protected int getHeight(UIXRenderingContext context, UINode node) {
        return ColorPaletteRenderer.getIntAttributeValue(context, node, HEIGHT_ATTR, 0);
    }

    protected Object getOnColorSelect(UIXRenderingContext context, UINode node) {
        return ColorPaletteRenderer.getAttributeValue(context, node, ON_COLOR_SELECT_ATTR, "_cfbs(event)");
    }

    @Override
    protected Object getOnClick(UIXRenderingContext context, UINode node) {
        Object onColorSelect;
        Object onClick = null;
        if (!ColorPaletteRenderer.isNetscape(context) && (onColorSelect = this.getOnColorSelect(context, node)) != null && (onClick = context.getLocalProperty(0, ON_CLICK_ATTR, null)) == null) {
            Object id = this.getID(context, node);
            if (id == null) {
                id = "null";
            }
            StringBuilder sb = new StringBuilder(id.toString().length() + onColorSelect.toString().length() + 21);
            sb.append("_onCPSel('");
            sb.append(id);
            sb.append("','");
            BaseDesktopUtils.escapeJS(sb, onColorSelect.toString(), true);
            if (ColorPaletteRenderer.isIE(context)) {
                sb.append("')");
            } else {
                sb.append("',event)");
            }
            sb.append("; return false");
            onClick = sb.toString();
            context.setLocalProperty(ON_CLICK_ATTR, onClick);
        }
        return XhtmlLafUtils.getChainedJS(super.getOnClick(context, node), onClick, true);
    }

    private static List<Color> _getColors(UIXRenderingContext context, UINode node, AttributeKey attributeKey) {
        Object attribValue = ColorPaletteRenderer.getAttributeValue(context, node, attributeKey, null);
        if (attribValue instanceof Color[]) {
            return Arrays.asList((Color[])attribValue);
        }
        return (List)attribValue;
    }
}

