/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreMessages;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.util.LabeledFacesMessage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelBoxRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelHeaderRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public class MessageBoxRenderer
extends XhtmlRenderer {
    private PropertyKey _textKey;
    private PropertyKey _messageKey;
    private PropertyKey _globalOnlyKey;
    private XhtmlRenderer _headerRenderer;
    private PanelBoxRenderer _boxRenderer;
    private static final Map<String, String> _RESOURCE_KEY_MAP = new HashMap<String, String>();

    public MessageBoxRenderer() {
        this(CoreMessages.TYPE);
    }

    protected MessageBoxRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._messageKey = type.findKey("message");
        this._globalOnlyKey = type.findKey("globalOnly");
        this._headerRenderer = new HeaderRenderer(type);
        this._boxRenderer = new BoxRenderer(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean renderMsgBox;
        RequestContext afContext = RequestContext.getCurrentInstance();
        if (afContext != null) {
            afContext.addPartialTarget(component);
        }
        ResponseWriter writer = context.getResponseWriter();
        Map origSkinResourceMap = rc.getSkinResourceKeyMap();
        rc.setSkinResourceKeyMap(_RESOURCE_KEY_MAP);
        boolean inlineValidation = RequestContext.ClientValidation.INLINE.equals((Object)RequestContext.getCurrentInstance().getClientValidation());
        boolean isGlobalOnly = this.isGlobalOnly(component, bean);
        boolean bl = renderMsgBox = isGlobalOnly && context.getMessages(null).hasNext() || !isGlobalOnly && inlineValidation || !isGlobalOnly && context.getMessages().hasNext();
        if (renderMsgBox) {
            if (!isGlobalOnly && inlineValidation && MessageBoxRenderer.supportsScripting(rc)) {
                writer.startElement("script", null);
                MessageBoxRenderer.renderScriptDeferAttribute(context, rc);
                MessageBoxRenderer.renderScriptTypeAttribute(context, rc);
                writer.writeText((Object)"TrPage.getInstance().addStyleClassMap( {'", null);
                writer.writeText((Object)"af|messages::list':'", null);
                writer.writeText((Object)rc.getStyleClass("af|messages::list"), null);
                writer.writeText((Object)"','af|messages::list-single':'", null);
                writer.writeText((Object)rc.getStyleClass("af|messages::list"), null);
                writer.writeText((Object)(" " + rc.getStyleClass("af|messages::list-single")), null);
                writer.writeText((Object)"','OraLink':'", null);
                writer.writeText((Object)rc.getStyleClass("OraLink"), null);
                writer.writeText((Object)"'} ); ", null);
                writer.writeText((Object)"TrMessageBox._registerMessageBox(\"", null);
                writer.writeText((Object)this.getClientId(context, component), null);
                writer.writeText((Object)"\");", null);
                writer.endElement("script");
            }
            this._boxRenderer.encodeAll(context, rc, component, bean);
        } else {
            writer.startElement("span", component);
            this.renderId(context, component);
            writer.endElement("span");
        }
        rc.setSkinResourceKeyMap(origSkinResourceMap);
    }

    protected void _renderContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean globalOnly = this.isGlobalOnly(component, bean);
        writer.startElement("div", component);
        MessageBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|messages::body");
        this._renderHeader(context, rc, component, bean);
        String message = this.getMessage(component, bean);
        if (message != null) {
            writer.startElement("div", null);
            MessageBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|messages::message-text");
            writer.write(message);
            writer.endElement("div");
        }
        writer.startElement("ol", null);
        String listId = this.getClientId(context, component) + "__LIST__";
        writer.writeAttribute("id", (Object)listId, null);
        String[] styleClasses = null;
        styleClasses = MessageUtils.multipleMessagesQueued(context, globalOnly) ? new String[]{"af|messages::list"} : new String[]{"af|messages::list", "af|messages::list-single"};
        MessageBoxRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])styleClasses);
        this._renderGlobalMessages(context, rc, component, bean);
        if (!globalOnly) {
            this._renderComponentMessages(context, rc, component, bean);
        }
        writer.endElement("ol");
        writer.endElement("div");
    }

    protected void _renderGlobalMessages(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator msgIter = context.getMessages(null);
        while (msgIter.hasNext()) {
            FacesMessage msg = (FacesMessage)msgIter.next();
            writer.startElement("li", null);
            String text = MessageUtils.getGlobalMessage(rc, msg.getSummary(), msg.getDetail());
            this.renderPossiblyFormattedText(context, text);
            writer.endElement("li");
        }
    }

    protected void _renderComponentMessages(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator idIter = context.getClientIdsWithMessages();
        while (idIter.hasNext()) {
            String id = (String)idIter.next();
            if (id == null) continue;
            Iterator msgIter = context.getMessages(id);
            while (msgIter.hasNext()) {
                FacesMessage msg = (FacesMessage)msgIter.next();
                writer.startElement("li", null);
                this._renderMessageAnchor(context, rc, msg, id);
                String text = MessageUtils.getClientMessage(rc, msg.getSummary(), msg.getDetail());
                boolean isNullLabel = false;
                if (msg instanceof LabeledFacesMessage) {
                    LabeledFacesMessage labeledMsg = (LabeledFacesMessage)msg;
                    String labelString = labeledMsg.getLabelAsString(context);
                    if (labelString == null || labelString.length() == 0) {
                        isNullLabel = true;
                    }
                } else {
                    isNullLabel = true;
                }
                if (isNullLabel && text.charAt(0) == '-' && text.charAt(1) == ' ') {
                    text = text.substring(2);
                }
                this.renderPossiblyFormattedText(context, text);
                writer.endElement("li");
            }
        }
    }

    protected void _renderHeader(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRenderer(context, rc, component, bean, this._headerRenderer);
    }

    protected void _renderMessageAnchor(FacesContext context, RenderingContext rc, FacesMessage msg, String componentId) throws IOException {
        LabeledFacesMessage labeledMsg;
        String labelString;
        ResponseWriter writer = context.getResponseWriter();
        if (componentId == null) {
            return;
        }
        if (msg instanceof LabeledFacesMessage && (labelString = (labeledMsg = (LabeledFacesMessage)msg).getLabelAsString(context)) != null && labelString.length() > 0) {
            String anchor = MessageUtils.getAnchor(componentId);
            writer.startElement("a", null);
            MessageBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraLink");
            writer.writeAttribute("href", (Object)("#" + anchor), null);
            writer.write(labelString);
            writer.endElement("a");
            writer.write(32);
        }
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    protected String getText(UIComponent component, FacesBean bean) {
        return (String)this.resolveProperty(bean, this._textKey);
    }

    protected String getMessage(UIComponent component, FacesBean bean) {
        return (String)this.resolveProperty(bean, this._messageKey);
    }

    protected boolean isGlobalOnly(UIComponent component, FacesBean bean) {
        return (Boolean)this.resolveProperty(bean, this._globalOnlyKey, true);
    }

    static {
        _RESOURCE_KEY_MAP.put("af_panelHeader.INFORMATION", "af_messages.INFORMATION");
        _RESOURCE_KEY_MAP.put("af_panelHeader.WARNING", "af_messages.WARNING");
        _RESOURCE_KEY_MAP.put("af_panelHeader.ERROR", "af_messages.ERROR");
        _RESOURCE_KEY_MAP.put("af_panelHeader.CONFIRMATION", "af_messages.CONFIRMATION");
        _RESOURCE_KEY_MAP.put("af|panelHeader::error-icon", "af|messages::error-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::warning-icon", "af|messages::warning-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::info-icon", "af|messages::info-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::confirmation-icon", "af|messages::confirmation-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::error", "af|messages::error");
        _RESOURCE_KEY_MAP.put("af|panelHeader", "af|messages::header");
        _RESOURCE_KEY_MAP.put("af|panelBox::light", "af|messages");
        _RESOURCE_KEY_MAP.put("af|panelBox::top-start", "af|messages::top-start");
        _RESOURCE_KEY_MAP.put("af|panelBox::top", "af|messages::top");
        _RESOURCE_KEY_MAP.put("af|panelBox::top-end", "af|messages::top-end");
        _RESOURCE_KEY_MAP.put("af|panelBox::start", "af|messages::start");
        _RESOURCE_KEY_MAP.put("af|panelBox::end", "af|messages::end");
        _RESOURCE_KEY_MAP.put("af|panelBox::bottom-start", "af|messages::bottom-start");
        _RESOURCE_KEY_MAP.put("af|panelBox::bottom", "af|messages::bottom");
        _RESOURCE_KEY_MAP.put("af|panelBox::bottom-end", "af|messages::bottom-end");
    }

    private class BoxRenderer
    extends PanelBoxRenderer {
        public BoxRenderer(FacesBean.Type type) {
            super(type);
        }

        @Override
        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return true;
        }

        @Override
        protected String getBackground(UIComponent component, FacesBean bean) {
            return "light";
        }

        @Override
        protected String getInlineStyle(UIComponent component, FacesBean bean) {
            String inlineStyle = super.getInlineStyle(component, bean);
            boolean inlineValidation = RequestContext.ClientValidation.INLINE.equals((Object)RequestContext.getCurrentInstance().getClientValidation());
            if (!inlineValidation) {
                return inlineStyle;
            }
            boolean hasMessages = FacesContext.getCurrentInstance().getMessages().hasNext();
            if (hasMessages) {
                return inlineStyle;
            }
            if (inlineStyle != null) {
                return inlineStyle + ";display:none;";
            }
            return "display:none;";
        }

        @Override
        protected boolean hasChildren(UIComponent component) {
            return true;
        }

        @Override
        protected void renderBody(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, Object icon, Object text) throws IOException {
            MessageBoxRenderer.this._renderContent(context, rc, component, bean);
        }
    }

    private class HeaderRenderer
    extends PanelHeaderRenderer {
        public HeaderRenderer(FacesBean.Type type) {
            super(type);
        }

        @Override
        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return false;
        }

        @Override
        protected void renderEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        }

        @Override
        protected String getMessageType(UIComponent component, FacesBean bean) {
            String messageType = null;
            FacesMessage.Severity maxSeverity = FacesContext.getCurrentInstance().getMaximumSeverity();
            if (maxSeverity == null) {
                messageType = "error";
            } else if (FacesMessage.SEVERITY_FATAL.equals(maxSeverity)) {
                messageType = "error";
            } else if (FacesMessage.SEVERITY_ERROR.equals(maxSeverity)) {
                messageType = "error";
            } else if (FacesMessage.SEVERITY_WARN.equals(maxSeverity)) {
                messageType = "warning";
            } else if (FacesMessage.SEVERITY_INFO.equals(maxSeverity)) {
                messageType = "info";
            }
            return messageType;
        }

        @Override
        protected String getText(RenderingContext rc, UIComponent component, FacesBean bean, String messageType) {
            String text = MessageBoxRenderer.this.getText(component, bean);
            if (text != null) {
                return text;
            }
            return super.getText(rc, component, bean, messageType);
        }

        @Override
        protected String getMessageIconName(String messageType) {
            String iconName = null;
            if ("error".equals(messageType)) {
                iconName = "af|messages::error-icon";
            } else if ("warning".equals(messageType)) {
                iconName = "af|messages::warning-icon";
            } else if ("info".equals(messageType)) {
                iconName = "af|messages::info-icon";
            } else if ("confirmation".equals(messageType)) {
                iconName = "af|messages::confirmation-icon";
            }
            assert (iconName != null || "none".equals(messageType));
            return iconName;
        }
    }
}

