/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.Collections;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanImpl;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.component.UIXFacesBean;
import org.apache.myfaces.trinidad.util.CollectionUtils;

public class UIXFacesBeanImpl
extends FacesBeanImpl
implements UIXFacesBean {
    private static final Set<PropertyKey> _ID_KEY_SET = Collections.singleton(UIXComponentBase.ID_KEY);
    private FacesBean.Type _type;
    private UIXComponent _component;

    @Override
    public final FacesBean.Type getType() {
        return this._type;
    }

    public final UIXComponent getComponent() {
        return this._component;
    }

    @Override
    public void init(UIXComponent component, FacesBean.Type type) {
        if (this._component != null && this._component != component) {
            throw new IllegalStateException("FacesBean Component Changed");
        }
        if (this._type != null && this._type != type) {
            throw new IllegalStateException("FacesBean Type Changed");
        }
        if (!(component instanceof UIXComponentBase)) {
            throw new IllegalArgumentException(((Object)((Object)component)).getClass() + " is not a UIXComponentBase");
        }
        if (component == null) {
            throw new NullPointerException("UIXFacesBean must have a component");
        }
        this._type = type;
        this._component = component;
    }

    @Override
    public Set<PropertyKey> keySet() {
        Set<PropertyKey> baseSet = super.keySet();
        if (baseSet.isEmpty()) {
            return _ID_KEY_SET;
        }
        return CollectionUtils.compositeSet(baseSet, _ID_KEY_SET);
    }

    @Override
    public void setPropertyImpl(PropertyKey key, Object value) {
        if (key == UIXComponentBase.ID_KEY) {
            this._component.setId((String)value);
        } else {
            super.setPropertyImpl(key, value);
        }
    }

    @Override
    protected Object getLocalPropertyImpl(PropertyKey key) {
        if (key == UIXComponentBase.ID_KEY) {
            return this._component.getId();
        }
        return super.getLocalPropertyImpl(key);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] addIdState = new Object[]{this._component.getId(), super.saveState(context)};
        return addIdState;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] addIdState = (Object[])state;
        assert (addIdState.length == 2);
        this._component.setId((String)addIdState[0]);
        super.restoreState(context, addIdState[1]);
    }
}

