/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinProvider;
import org.apache.myfaces.trinidad.skin.SkinVersion;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;
import org.apache.myfaces.trinidadinternal.skin.SkinExtension;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;
import org.apache.myfaces.trinidadinternal.skin.provider.ExternalSkinProvider;

public class SkinFactoryImpl
extends SkinFactory {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinFactoryImpl.class);

    public Skin createSkin(ExternalContext externalContext, SkinMetadata baseSkinMetadata, SkinMetadata skinMetadata) {
        if (externalContext == null || baseSkinMetadata == null || skinMetadata == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FC_SKIN_BASE_SKIN_METADATA"));
        }
        if (baseSkinMetadata.getId() != null && !baseSkinMetadata.getId().equals(skinMetadata.getBaseSkinId())) {
            throw new IllegalArgumentException(_LOG.getMessage("INVALID_BASE_SKIN_ID"));
        }
        Skin baseSkin = SkinProvider.getCurrentInstance((ExternalContext)externalContext).getSkin(externalContext, baseSkinMetadata);
        if (baseSkin == null) {
            throw new IllegalArgumentException(_LOG.getMessage("INVALID_BASE_SKIN"));
        }
        return new SkinExtension(baseSkin, skinMetadata);
    }

    public Skin createSkin(ExternalContext externalContext, SkinMetadata skinMetadata) {
        if (externalContext == null || skinMetadata == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FC_SKIN_METADATA"));
        }
        if (skinMetadata.getBaseSkinId() == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_BASE_SKIN_ID"));
        }
        SkinMetadata baseSkinMetadata = new SkinMetadata.Builder().id(skinMetadata.getBaseSkinId()).build();
        return this.createSkin(externalContext, baseSkinMetadata, skinMetadata);
    }

    @Deprecated
    public void addSkin(String skinId, Skin skin) {
        Skin previousValue;
        if (skinId == null || skin == null) {
            _LOG.warning("CANNOT_ADD_SKIN");
            return;
        }
        SkinMetadata.RenderKitId renderKitId = SkinMetadata.RenderKitId.fromId((String)skin.getRenderKitId());
        SkinMetadata.Builder builder = new SkinMetadata.Builder().id(skinId).family(skin.getFamily()).version(skin.getVersion()).renderKitId(renderKitId);
        if (skin.getBaseSkin() != null) {
            builder.baseSkinId(skin.getBaseSkin().getId());
        }
        if (skin.getSkinFeatures() != null) {
            builder.features(new SkinFeatures(skin.getSkinFeatures()));
        }
        if ((previousValue = this._getExternalSkinProvider().addSkin(builder.build(), skin)) != null) {
            _LOG.warning("DUPLICATE_ADD_SKIN_TO_SKIN_FACTORY", (Object)skinId);
        }
    }

    @Deprecated
    public Skin getSkin(FacesContext context, String skinId) {
        context = SkinUtils.getNonNullFacesContext(context);
        if (skinId == null) {
            _LOG.warning("CANNOT_GET_SKIN_WITH_NULL_SKINID");
            return null;
        }
        ExternalContext ec = context.getExternalContext();
        SkinMetadata skinMetadata = new SkinMetadata.Builder().id(skinId).build();
        return SkinProvider.getCurrentInstance((ExternalContext)ec).getSkin(ec, skinMetadata);
    }

    @Deprecated
    public Skin getSkin(FacesContext context, String family, String renderKitId) {
        return this.getSkin(context, family, renderKitId, null);
    }

    @Deprecated
    public Skin getSkin(FacesContext context, String family, String renderKitId, String version) {
        context = SkinUtils.getNonNullFacesContext(context);
        if (version == null) {
            version = "";
        }
        if (family == null) {
            throw new NullPointerException("Null skin family");
        }
        SkinVersion skinVersion = new SkinVersion(version);
        SkinMetadata.RenderKitId renderKitIdObj = SkinMetadata.RenderKitId.fromId((String)renderKitId);
        SkinMetadata metadata = new SkinMetadata.Builder().family(family).version(skinVersion).renderKitId(renderKitIdObj).build();
        ExternalContext ec = context.getExternalContext();
        Skin matchingSkin = SkinProvider.getCurrentInstance((ExternalContext)ec).getSkin(ec, metadata);
        return matchingSkin == null ? null : new RequestSkinWrapper(matchingSkin);
    }

    @Deprecated
    public Iterator<String> getSkinIds() {
        FacesContext context = SkinUtils.getNonNullFacesContext(null);
        ExternalContext extContext = context.getExternalContext();
        ExternalSkinProvider extSkinProvider = ExternalSkinProvider.getCurrentInstance(extContext);
        Collection metadatas = extSkinProvider.getSkinMetadata(extContext);
        HashSet<String> ids = new HashSet<String>();
        for (SkinMetadata metadata : metadatas) {
            ids.add(metadata.getId());
        }
        return ids.iterator();
    }

    @Deprecated
    public void reload() {
        this._getExternalSkinProvider().reload();
    }

    private ExternalSkinProvider _getExternalSkinProvider() {
        FacesContext context = SkinUtils.getNonNullFacesContext(null);
        ExternalContext extContext = context.getExternalContext();
        return ExternalSkinProvider.getCurrentInstance(extContext);
    }
}

