/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.TreeModel;

public class RowKeySetTreeImpl
extends RowKeySet
implements Serializable {
    private Node<Object> _root;
    private transient TreeModel _model = null;
    private static final long serialVersionUID = 1L;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RowKeySetTreeImpl.class);

    public RowKeySetTreeImpl() {
        this(false);
    }

    public RowKeySetTreeImpl(boolean addAll) {
        this._root = new Node(addAll);
    }

    @Override
    public boolean contains(Object rowKey) {
        return this._isContained(rowKey);
    }

    @Override
    @Deprecated
    public boolean isContainedByDefault() {
        TreeModel model = this.getCollectionModel();
        if (model != null) {
            Object rowkey = model.getRowKey();
            return (RowKeySetTreeImpl)this.new Search().find((Object)rowkey).isDefaultContained;
        }
        return false;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this._root.isDefaultContained) {
            return new PathIterator();
        }
        return new NodeIterator();
    }

    @Override
    public boolean add(Object rowKey) {
        return this._setContained(rowKey, true);
    }

    @Override
    public boolean remove(Object rowKey) {
        return this._setContained(rowKey, false);
    }

    @Override
    public void addAll() {
        this._selectAll(true);
    }

    @Override
    public void removeAll() {
        this._selectAll(false);
    }

    @Override
    public boolean addAll(Collection<? extends Object> other) {
        if (other instanceof RowKeySetTreeImpl) {
            RowKeySetTreeImpl otherset = (RowKeySetTreeImpl)other;
            return this._processOperation(this._root, otherset._root, true);
        }
        return super.addAll(other);
    }

    @Override
    public boolean removeAll(Collection<?> other) {
        if (other instanceof RowKeySetTreeImpl) {
            RowKeySetTreeImpl otherset = (RowKeySetTreeImpl)other;
            return this._processOperation(this._root, otherset._root, false);
        }
        return super.removeAll(other);
    }

    private boolean _processOperation(Node<Object> set1, Node<Object> set2, boolean add) {
        boolean hasChanges = false;
        if (set2.isDefaultContained && set1.keySet().retainAll(set2.keySet())) {
            hasChanges = true;
        }
        boolean addAll = add ^ set1.isDefaultContained;
        for (Map.Entry en : set2.entrySet()) {
            Object segment = en.getKey();
            Node subset2 = (Node)en.getValue();
            Node<Object> subset1 = (Node<Object>)set1.get(segment);
            if (subset1 == null) {
                if (!addAll) continue;
                subset1 = new Node<Object>(set1, segment);
                hasChanges = true;
            }
            if (!this._processOperation(subset1, subset2, add)) continue;
            hasChanges = true;
        }
        if (set2.isDefaultContained && set1.isDefaultContained != add) {
            set1.isDefaultContained = add;
            set1.isDifferent = !set1.isDifferent;
            hasChanges = true;
        }
        if (set2.isDefaultContained ^ set2.isDifferent && (set1.isDefaultContained ^ set1.isDifferent) != add) {
            set1.isDifferent = !set1.isDifferent;
            hasChanges = true;
        }
        return hasChanges;
    }

    @Override
    public void clear() {
        this._root.clear();
        this._root.isDifferent = false;
        this._root.isDefaultContained = false;
    }

    @Override
    public int getSize() {
        return this._getSize(null, this._root, this.getCollectionModel(), false);
    }

    @Override
    public int size() {
        return this._getSize(null, this._root, this.getCollectionModel(), true);
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public final void setCollectionModel(CollectionModel model) {
        if (model != null && !(model instanceof TreeModel)) {
            throw new IllegalArgumentException();
        }
        this._model = (TreeModel)model;
    }

    @Override
    public RowKeySetTreeImpl clone() {
        RowKeySetTreeImpl clone = (RowKeySetTreeImpl)super.clone();
        clone._root = this._root.clone();
        return clone;
    }

    @Override
    @Deprecated
    public void invertAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TreeModel getCollectionModel() {
        return this._model;
    }

    private int _getTreeSize(TreeModel model, Set<Object> exclusions) {
        int sz = 0;
        int i = 0;
        while (true) {
            model.setRowIndex(i);
            if (model.isRowAvailable()) {
                Object rowkey = model.getRowKey();
                if (!exclusions.contains(rowkey)) {
                    ++sz;
                    if (model.isContainer()) {
                        model.enterContainer();
                        Set<Object> empty = Collections.emptySet();
                        sz += this._getTreeSize(model, empty);
                        model.exitContainer();
                    }
                }
            } else {
                return sz;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getSize(Object rowkey, Node<Object> set, TreeModel model, boolean fetchall) {
        int sz;
        int n = sz = rowkey != null && set.isDefaultContained ^ set.isDifferent ? 1 : 0;
        if (set.isDefaultContained) {
            if (!fetchall || model == null) {
                return -1;
            }
            Object old = model.getRowKey();
            try {
                model.setRowKey(rowkey);
                if (rowkey == null) {
                    sz += this._getTreeSize(model, set.keySet());
                } else if (model.isContainer()) {
                    model.enterContainer();
                    sz += this._getTreeSize(model, set.keySet());
                }
            }
            finally {
                model.setRowKey(old);
            }
        }
        for (Map.Entry en : set.entrySet()) {
            Node subset;
            Object newrowkey = en.getKey();
            int size = this._getSize(newrowkey, subset = (Node)en.getValue(), model, fetchall);
            if (size < 0) {
                return -1;
            }
            sz += size;
        }
        return sz;
    }

    private void _selectAll(final boolean isSelectAll) {
        Search search = new Search(){

            @Override
            protected boolean create(Node<Object> parent, Object rowkey) {
                return parent.isDefaultContained != isSelectAll;
            }

            @Override
            protected Node<Object> found(Node<Object> child) {
                child.isDefaultContained = isSelectAll;
                child.isDifferent = false;
                child.clear();
                return null;
            }
        };
        TreeModel model = this.getCollectionModel();
        Object rowkey = model.getRowKey();
        search.find(rowkey);
    }

    private boolean _isContained(Object rowkey) {
        Search search = new Search(){

            @Override
            protected Node<Object> notFound(Node<Object> parent, Object rowkey) {
                return parent.isDefaultContained ? parent : null;
            }

            @Override
            protected Node<Object> found(Node<Object> child) {
                return child.isDefaultContained ^ child.isDifferent ? child : null;
            }
        };
        return search.find(rowkey) != null;
    }

    private boolean _setContained(Object rowkey, final boolean isContained) {
        Search search = new Search(){

            @Override
            protected boolean create(Node<Object> parent, Object rowkey) {
                return parent.isDefaultContained != isContained;
            }

            @Override
            protected Node<Object> notFound(Node<Object> parent, Object rowkey) {
                return null;
            }
        };
        Node<Object> current = search.find(rowkey);
        if (current != null && (current.isDefaultContained ^ current.isDifferent) != isContained) {
            current.isDifferent = !current.isDifferent;
            return true;
        }
        return false;
    }

    private static boolean _advanceToNextItem(TreeModel model, int minDepth, boolean recurseChildren) {
        assert (minDepth >= 0);
        if (recurseChildren && model.isRowAvailable() && model.isContainer()) {
            model.enterContainer();
            model.setRowIndex(-1);
        }
        while (true) {
            int ri = model.getRowIndex();
            model.setRowIndex(ri + 1);
            if (model.isRowAvailable()) {
                return true;
            }
            int depth = model.getDepth();
            if (depth <= minDepth) {
                return false;
            }
            model.exitContainer();
        }
    }

    private boolean _containsDefaultNodes() {
        if (this._root.isDefaultContained) {
            return true;
        }
        SetLoop loop = new SetLoop(){

            @Override
            protected boolean next(Object rowKey, Node<Object> value) {
                return value.isDefaultContained;
            }
        };
        return loop.run(this._root);
    }

    private void _dumpFlags() {
        System.out.println("root " + this._root.isDefaultContained + " " + this._root.isDifferent);
        SetLoop loop = new SetLoop(){

            @Override
            protected boolean next(Object rowKey, Node<Object> value) {
                System.out.println(rowKey + " " + value.isDefaultContained + " " + value.isDifferent);
                return false;
            }
        };
        loop.run(this._root);
    }

    private class NodeIterator
    extends PathIterator {
        private Stack<Iterator<Map.Entry<Object, Node<Object>>>> _iteratorStack;
        private Iterator<Map.Entry<Object, Node<Object>>> _currIterator;
        private int _minDepth;

        public NodeIterator() {
            super(null);
            this._iteratorStack = new Stack();
            this._currIterator = RowKeySetTreeImpl.this._root.entrySet().iterator();
            this._value = RowKeySetTreeImpl.this.getCollectionModel() == null || RowKeySetTreeImpl.this.isEmpty() ? null : this.nextItem();
        }

        @Override
        protected Object nextItem() {
            Object nextKey = null;
            while ((nextKey = this._nextEntry()) == null && this._iteratorStack.size() > 0) {
                if (this._currPath != null) continue;
                this._currIterator = this._iteratorStack.pop();
            }
            return nextKey;
        }

        private Object _nextEntry() {
            Object nextKey = null;
            if (this._currPath != null) {
                nextKey = this.nextModelKey(this._minDepth);
                if (nextKey == null) {
                    this._currPath = null;
                    if (this._iteratorStack.size() > 0) {
                        this._currIterator = this._iteratorStack.pop();
                    }
                    this._nextEntry();
                }
            } else {
                while (nextKey == null && this._currIterator.hasNext()) {
                    Map.Entry<Object, Node<Object>> nextNode = this._currIterator.next();
                    if (RowKeySetTreeImpl.this._isContained(nextNode.getKey())) {
                        nextKey = nextNode.getKey();
                    }
                    if (!nextNode.getValue().isEmpty()) {
                        this._iteratorStack.push(this._currIterator);
                        this._currIterator = nextNode.getValue().entrySet().iterator();
                    }
                    if (!nextNode.getValue().isDefaultContained) continue;
                    this._currPath = nextNode.getKey();
                    TreeModel model = RowKeySetTreeImpl.this.getCollectionModel();
                    Object oldPath = model.getRowKey();
                    model.setRowKey(this._currPath);
                    this._minDepth = model.getDepth() + 1;
                    model.setRowKey(oldPath);
                    return nextKey;
                }
            }
            return nextKey;
        }
    }

    private class PathIterator
    implements Iterator<Object> {
        protected Object _value;
        protected Object _currPath = null;

        PathIterator() {
            this._value = RowKeySetTreeImpl.this.getCollectionModel() == null || RowKeySetTreeImpl.this.isEmpty() ? null : this.nextItem();
        }

        PathIterator(Object noop) {
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this._value;
            this._value = this.nextItem();
            return value;
        }

        @Override
        public boolean hasNext() {
            return this._value != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Object nextItem() {
            return this.nextModelKey(0);
        }

        protected Object nextModelKey(int minDepth) {
            TreeModel model = RowKeySetTreeImpl.this.getCollectionModel();
            if (model == null) {
                return null;
            }
            Object oldPath = model.getRowKey();
            try {
                model.setRowKey(this._currPath);
                while (true) {
                    boolean searchChildren;
                    boolean hasMore;
                    if (!(hasMore = RowKeySetTreeImpl._advanceToNextItem(model, minDepth, searchChildren = this._containsSubtree(this._currPath)))) {
                        Object var6_6 = null;
                        return var6_6;
                    }
                    this._currPath = model.getRowKey();
                    if (!RowKeySetTreeImpl.this.contains(this._currPath)) continue;
                    Object object = this._currPath;
                    return object;
                }
            }
            finally {
                model.setRowKey(oldPath);
            }
        }

        private boolean _containsSubtree(Object rowkey) {
            Search search = new Search(){

                @Override
                protected Node<Object> notFound(Node<Object> parent, Object rowkey) {
                    return parent.isDefaultContained ? parent : null;
                }
            };
            Node<Object> current = search.find(rowkey);
            return current != null && (!current.isEmpty() || current.isDefaultContained);
        }
    }

    private static abstract class SetLoop {
        public boolean run(Node<Object> set) {
            for (Map.Entry en : set.entrySet()) {
                Node subset;
                Object keyEnt = en.getKey();
                if (this.next(keyEnt, subset = (Node)en.getValue())) {
                    return true;
                }
                if (!this.run(subset)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean next(Object var1, Node<Object> var2);
    }

    private class Search {
        protected boolean create(Node<Object> parent, Object rowkey) {
            return false;
        }

        protected Node<Object> notFound(Node<Object> parent, Object rowkey) {
            return parent;
        }

        protected Node<Object> found(Node<Object> result) {
            return result;
        }

        public Node<Object> find(Object rowkey) {
            Node current = RowKeySetTreeImpl.this._root;
            if (rowkey != null) {
                TreeModel model = RowKeySetTreeImpl.this.getCollectionModel();
                if (model == null) {
                    return this.notFound(current, rowkey);
                }
                List<Object> parentkeys = model.getAllAncestorContainerRowKeys(rowkey);
                ArrayList<Object> allkeys = new ArrayList<Object>(parentkeys.size() + 1);
                allkeys.addAll(parentkeys);
                allkeys.add(rowkey);
                for (Object e : allkeys) {
                    Node next = (Node)current.get(e);
                    if (next == null) {
                        if (this.create(current, e)) {
                            next = new Node(current, e);
                        } else {
                            return this.notFound(current, e);
                        }
                    }
                    current = next;
                }
            }
            return this.found(current);
        }
    }

    private static final class Node<K>
    extends LinkedHashMap<K, Node<K>> {
        public boolean isDifferent = false;
        public boolean isDefaultContained = false;
        private static final long serialVersionUID = 1L;

        public Node(boolean isDefaultContained) {
            this.isDefaultContained = isDefaultContained;
        }

        public Node(Node<K> parent, K segment) {
            this(parent.isDefaultContained);
            parent.put(segment, this);
        }

        private void _deepClone(Node<K> root) {
            for (Map.Entry entry : root.entrySet()) {
                Node original = (Node)entry.getValue();
                Object clone = original.clone();
                entry.setValue(clone);
            }
        }

        @Override
        public Node<K> clone() {
            Node clone = (Node)super.clone();
            this._deepClone(clone);
            return clone;
        }
    }
}

