/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.Log;
import io.questdb.log.LogError;
import io.questdb.log.LogRecord;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Chars;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Rnd;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.locks.LockSupport;

public class LogAlertSocket
implements Closeable {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 9093;
    public static final int IN_BUFFER_SIZE = 0x200000;
    public static final int OUT_BUFFER_SIZE = 0x400000;
    public static final long RECONNECT_DELAY_NANO = 250000000L;
    public static final String localHostIp;
    private static final int HOSTS_LIMIT = 12;
    private final String[] alertHosts = new String[12];
    private final int[] alertPorts = new int[12];
    private final String defaultHost;
    private final int defaultPort;
    private final int inBufferSize;
    private final Log log;
    private final NetworkFacade nf;
    private final int outBufferSize;
    private final Rnd rand;
    private final long reconnectDelay;
    private final Runnable onReconnectRef = this::onReconnect;
    private final StringSink responseSink = new StringSink();
    private long addressInfoAddr = -1L;
    private int alertHostIdx;
    private int alertHostsCount;
    private String alertTargets;
    private long inBufferPtr;
    private long outBufferPtr;
    private int socketFd = -1;

    public LogAlertSocket(NetworkFacade nf, String alertTargets, Log log) {
        this(nf, alertTargets, 0x200000, 0x400000, 250000000L, DEFAULT_HOST, 9093, log);
    }

    public LogAlertSocket(NetworkFacade nf, String alertTargets, int inBufferSize, int outBufferSize, long reconnectDelay, String defaultHost, int defaultPort, Log log) {
        this.nf = nf;
        this.log = log;
        this.rand = new Rnd(NanosecondClockImpl.INSTANCE.getTicks(), MicrosecondClockImpl.INSTANCE.getTicks());
        this.alertTargets = alertTargets;
        this.defaultHost = defaultHost;
        this.defaultPort = defaultPort;
        this.parseAlertTargets();
        this.inBufferSize = inBufferSize;
        this.inBufferPtr = Unsafe.malloc(inBufferSize, 43);
        this.outBufferSize = outBufferSize;
        this.outBufferPtr = Unsafe.malloc(outBufferSize, 43);
        this.reconnectDelay = reconnectDelay;
    }

    @Override
    public void close() {
        this.freeSocketAndAddress();
        if (this.outBufferPtr != 0L) {
            Unsafe.free(this.outBufferPtr, this.outBufferSize, 43);
            this.outBufferPtr = 0L;
        }
        if (this.inBufferPtr != 0L) {
            Unsafe.free(this.inBufferPtr, this.inBufferSize, 43);
            this.inBufferPtr = 0L;
        }
    }

    public void connect() {
        this.addressInfoAddr = this.nf.getAddrInfo(this.alertHosts[this.alertHostIdx], this.alertPorts[this.alertHostIdx]);
        if (this.addressInfoAddr == -1L) {
            this.logNetworkConnectError("Could not connect with");
        } else {
            this.socketFd = this.nf.socketTcp(true);
            if (this.socketFd > -1) {
                if (this.nf.connectAddrInfo(this.socketFd, this.addressInfoAddr) != 0) {
                    this.logNetworkConnectError("Could not connect with");
                    this.freeSocketAndAddress();
                }
            } else {
                this.logNetworkConnectError("Could create TCP socket with");
                this.freeSocketAndAddress();
            }
        }
    }

    public long getInBufferPtr() {
        return this.inBufferPtr;
    }

    public int getInBufferSize() {
        return this.inBufferSize;
    }

    public long getOutBufferPtr() {
        return this.outBufferPtr;
    }

    public int getOutBufferSize() {
        return this.outBufferSize;
    }

    public boolean send(int len, Runnable onReconnect) {
        boolean success;
        int maxSendAttempts;
        int sendAttempts;
        if (len < 1) {
            return false;
        }
        for (sendAttempts = maxSendAttempts = 2 * this.alertHostsCount; sendAttempts > 0; --sendAttempts) {
            if (this.socketFd > 0) {
                int n;
                int remaining = len;
                long p = this.outBufferPtr;
                boolean sendFail = false;
                while (remaining > 0) {
                    n = this.nf.send(this.socketFd, p, remaining);
                    if (n > 0) {
                        remaining -= n;
                        p += (long)n;
                        continue;
                    }
                    this.$currentAlertHost(this.log.info().$("Could not send")).$(" [errno=").$(this.nf.errno()).$(", size=").$(n).$(", log=").$utf8(this.outBufferPtr, this.outBufferPtr + (long)len).I$();
                    sendFail = true;
                    break;
                }
                if (!sendFail && (n = this.nf.recv(this.socketFd, p = this.inBufferPtr, this.inBufferSize)) > 0) {
                    this.logResponse(n);
                    break;
                }
            }
            this.freeSocketAndAddress();
            int alertHostIdx = this.alertHostIdx;
            this.alertHostIdx = (this.alertHostIdx + 1) % this.alertHostsCount;
            LogRecord logFailOver = this.$alertHost(this.alertHostIdx, this.$alertHost(alertHostIdx, this.log.info().$("Failing over from")).$(" to"));
            if (alertHostIdx == this.alertHostIdx) {
                logFailOver.$(" with a delay of ").$(this.reconnectDelay / 1000000L).$(" millis (as it is the same alert manager)").$();
                onReconnect.run();
            } else {
                logFailOver.$();
            }
            this.connect();
        }
        boolean bl = success = sendAttempts > 0;
        if (!success) {
            this.log.info().$("None of the configured alert managers are accepting alerts.\n").$("Giving up sending after ").$(maxSendAttempts).$(" attempts: [").$utf8(this.outBufferPtr, this.outBufferPtr + (long)len).I$();
        }
        return success;
    }

    public boolean send(int len) {
        return this.send(len, this.onReconnectRef);
    }

    private static boolean isContentLength(CharSequence tok, int lo, int hi) {
        return hi - lo > 13 && (tok.charAt(lo++) | 0x20) == 99 && (tok.charAt(lo++) | 0x20) == 111 && (tok.charAt(lo++) | 0x20) == 110 && (tok.charAt(lo++) | 0x20) == 116 && (tok.charAt(lo++) | 0x20) == 101 && (tok.charAt(lo++) | 0x20) == 110 && (tok.charAt(lo++) | 0x20) == 116 && (tok.charAt(lo++) | 0x20) == 45 && (tok.charAt(lo++) | 0x20) == 108 && (tok.charAt(lo++) | 0x20) == 101 && (tok.charAt(lo++) | 0x20) == 110 && (tok.charAt(lo++) | 0x20) == 103 && (tok.charAt(lo++) | 0x20) == 116 && (tok.charAt(lo) | 0x20) == 104;
    }

    private LogRecord $alertHost(int idx, LogRecord logRecord) {
        return logRecord.$(" [").$(idx).$("] ").$(this.alertHosts[idx]).$(':').$(this.alertPorts[idx]);
    }

    private LogRecord $currentAlertHost(LogRecord logRecord) {
        return this.$alertHost(this.alertHostIdx, logRecord);
    }

    private void freeSocketAndAddress() {
        if (this.addressInfoAddr != -1L) {
            this.nf.freeAddrInfo(this.addressInfoAddr);
            this.addressInfoAddr = -1L;
        }
        if (this.socketFd != -1) {
            this.nf.close(this.socketFd);
            this.socketFd = -1;
        }
    }

    private void logNetworkConnectError(CharSequence message) {
        this.$currentAlertHost(this.log.info().$(message)).$(" [errno=").$(this.nf.errno()).I$();
    }

    private void onReconnect() {
        LockSupport.parkNanos(this.reconnectDelay);
    }

    private void parseAlertTargets() {
        if (this.alertTargets == null || this.alertTargets.isEmpty()) {
            this.setDefaultHostPort();
            return;
        }
        int startIdx = 0;
        int endIdx = this.alertTargets.length();
        if (Chars.isQuoted(this.alertTargets)) {
            ++startIdx;
            --endIdx;
        }
        while (this.alertTargets.charAt(startIdx) == ' ' && startIdx < endIdx - 1) {
            ++startIdx;
        }
        while (this.alertTargets.charAt(endIdx - 1) == ' ' && endIdx > startIdx) {
            --endIdx;
        }
        int len = endIdx - startIdx;
        if (len == 0) {
            this.setDefaultHostPort();
            return;
        }
        int hostIdx = startIdx;
        int portIdx = -1;
        block6: for (int i = startIdx; i < endIdx; ++i) {
            char c = this.alertTargets.charAt(i);
            switch (c) {
                case ':': {
                    if (portIdx != -1) {
                        throw new LogError(String.format("Unexpected ':' found at position %d: %s", i, this.alertTargets));
                    }
                    portIdx = i;
                    continue block6;
                }
                case ',': {
                    this.setHostPort(hostIdx, portIdx, i);
                    hostIdx = i + 1;
                    portIdx = -1;
                }
            }
        }
        this.setHostPort(hostIdx, portIdx, len);
        this.alertHostIdx = this.rand.nextInt(this.alertHostsCount);
    }

    private void setDefaultHostPort() {
        this.alertHosts[this.alertHostIdx] = this.defaultHost;
        this.alertPorts[this.alertHostIdx] = this.defaultPort;
        this.alertTargets = this.defaultHost + ":" + this.defaultPort;
        this.alertHostIdx = 0;
        this.alertHostsCount = 1;
        this.$currentAlertHost(this.log.info().$("Added default alert manager")).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHostPort(int hostIdx, int portLimit, int hostLimit) {
        boolean hostResolved = false;
        int hostEnd = hostLimit;
        if (portLimit == -1) {
            if (hostIdx + 1 > hostLimit) {
                this.alertHosts[this.alertHostsCount] = this.defaultHost;
                hostResolved = true;
            }
            this.alertPorts[this.alertHostsCount] = this.defaultPort;
        } else {
            if (hostIdx + 1 > portLimit) {
                this.alertHosts[this.alertHostsCount] = this.defaultHost;
                hostResolved = true;
            } else {
                hostEnd = portLimit;
            }
            if (portLimit + 2 > hostLimit) {
                this.alertPorts[this.alertHostsCount] = this.defaultPort;
            } else {
                int port = 0;
                int scale = 1;
                for (int i = hostLimit - 1; i > portLimit; --i) {
                    int c = this.alertTargets.charAt(i) - 48;
                    if (c > -1 && c < 10) {
                        port += c * scale;
                        scale *= 10;
                        continue;
                    }
                    throw new LogError(String.format("Invalid port value [%s] at position %d for alertTargets: %s", this.alertTargets.substring(portLimit + 1, hostLimit), portLimit + 1, this.alertTargets));
                }
                this.alertPorts[this.alertHostsCount] = port;
            }
        }
        LogRecord logRecord = this.log.info().$("Added alert manager [").$(this.alertHostsCount).$("]: ");
        try {
            if (!hostResolved) {
                String host = this.alertTargets.substring(hostIdx, hostEnd).trim();
                try {
                    this.alertHosts[this.alertHostsCount] = InetAddress.getByName(host).getHostAddress();
                    logRecord.$(host).$(" (").$(this.alertHosts[this.alertHostsCount]).$(')');
                }
                catch (UnknownHostException e) {
                    throw new LogError(String.format("Invalid host value [%s] at position %d for alertTargets: %s", host, hostIdx, this.alertTargets));
                }
            } else {
                logRecord.$(this.alertHosts[this.alertHostsCount]);
            }
            logRecord.$(':').$(this.alertPorts[this.alertHostsCount]);
            ++this.alertHostsCount;
        }
        finally {
            logRecord.$();
        }
    }

    String[] getAlertHosts() {
        return this.alertHosts;
    }

    int getAlertHostsCount() {
        return this.alertHostsCount;
    }

    int[] getAlertPorts() {
        return this.alertPorts;
    }

    String getAlertTargets() {
        return this.alertTargets;
    }

    String getDefaultAlertHost() {
        return this.defaultHost;
    }

    int getDefaultAlertPort() {
        return this.defaultPort;
    }

    long getReconnectDelay() {
        return this.reconnectDelay;
    }

    void logResponse(int len) {
        this.responseSink.clear();
        Chars.utf8Decode(this.inBufferPtr, this.inBufferPtr + (long)len, this.responseSink);
        int responseLen = this.responseSink.length();
        int contentLength = 0;
        int lineStart = 0;
        int colonIdx = -1;
        boolean headerEndFound = false;
        block6: for (int i = 0; i < responseLen; ++i) {
            switch (this.responseSink.charAt(i)) {
                case ':': {
                    if (colonIdx != -1) continue block6;
                    colonIdx = i;
                    continue block6;
                }
                case '\n': {
                    if (colonIdx != -1) {
                        if (LogAlertSocket.isContentLength(this.responseSink, lineStart, colonIdx)) {
                            char c;
                            int startSize;
                            int limSize = i - 1;
                            for (startSize = colonIdx + 1; startSize < responseLen && this.responseSink.charAt(startSize) == ' '; ++startSize) {
                            }
                            while (limSize > startSize && ((c = this.responseSink.charAt(limSize)) == '\r' || c == ' ')) {
                                --limSize;
                            }
                            try {
                                contentLength = Numbers.parseInt(this.responseSink, startSize, limSize + 1);
                            }
                            catch (NumericException e) {
                                this.$currentAlertHost(this.log.info().$("Received")).$(": ").$(this.responseSink).$();
                                return;
                            }
                        }
                        colonIdx = -1;
                    } else if (i - lineStart == 1 && this.responseSink.charAt(i - 1) == '\r') {
                        lineStart = i + 1;
                        headerEndFound = true;
                        continue block6;
                    }
                    lineStart = i + 1;
                }
            }
        }
        int start = headerEndFound && contentLength == responseLen - lineStart ? lineStart : 0;
        this.$currentAlertHost(this.log.info().$("Received")).$(": ").$(this.responseSink, start, responseLen).$();
    }

    static {
        try {
            localHostIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new LogError("Cannot access our ip address info");
        }
    }
}

