/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.synchronization;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.connectable.Connectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectableAdditionTracker {
    private static final Logger logger = LoggerFactory.getLogger(ConnectableAdditionTracker.class);
    private final Map<ComponentKey, Connectable> tracking = new HashMap<ComponentKey, Connectable>();

    public void addComponent(String instantiatedGroupId, String versionedComponentId, Connectable component) {
        ComponentKey key = new ComponentKey(instantiatedGroupId, versionedComponentId);
        if (this.tracking.containsKey(key)) {
            logger.debug("Component [{}] and Versioned Component ID [{}] added to Process Group [{}] but component with same Versioned ID already added", new Object[]{component, versionedComponentId, instantiatedGroupId});
        }
        this.tracking.putIfAbsent(key, component);
    }

    public Optional<Connectable> getComponent(String instantiatedGroupId, String versionedComponentId) {
        ComponentKey key = new ComponentKey(instantiatedGroupId, versionedComponentId);
        return Optional.ofNullable(this.tracking.get(key));
    }

    private static class ComponentKey {
        private final String instantiatedGroupId;
        private final String versionedComponentId;

        public ComponentKey(String instantiatedGroupid, String versionedComponentId) {
            this.instantiatedGroupId = instantiatedGroupid;
            this.versionedComponentId = versionedComponentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentKey that = (ComponentKey)o;
            return Objects.equals(this.instantiatedGroupId, that.instantiatedGroupId) && Objects.equals(this.versionedComponentId, that.versionedComponentId);
        }

        public int hashCode() {
            return Objects.hash(this.instantiatedGroupId, this.versionedComponentId);
        }
    }
}

