/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema;

import java.util.Map;
import org.apache.nifi.minifi.commons.schema.common.BaseSchema;
import org.apache.nifi.minifi.commons.schema.common.WritableSchema;

public class ComponentStatusRepositorySchema
extends BaseSchema
implements WritableSchema {
    public static final String BUFFER_SIZE_KEY = "buffer size";
    public static final String SNAPSHOT_FREQUENCY_KEY = "snapshot frequency";
    public static final int DEFAULT_BUFFER_SIZE = 1440;
    public static final String DEFAULT_SNAPSHOT_FREQUENCY = "1 min";
    private Number bufferSize = 1440;
    private String snapshotFrequency = "1 min";

    public ComponentStatusRepositorySchema() {
    }

    public ComponentStatusRepositorySchema(Map map) {
        this.bufferSize = this.getOptionalKeyAsType(map, BUFFER_SIZE_KEY, Number.class, "Component Status Repository", 1440);
        this.snapshotFrequency = this.getOptionalKeyAsType(map, SNAPSHOT_FREQUENCY_KEY, String.class, "Component Status Repository", DEFAULT_SNAPSHOT_FREQUENCY);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(BUFFER_SIZE_KEY, this.bufferSize);
        result.put(SNAPSHOT_FREQUENCY_KEY, this.snapshotFrequency);
        return result;
    }

    public Number getBufferSize() {
        return this.bufferSize;
    }

    public String getSnapshotFrequency() {
        return this.snapshotFrequency;
    }
}

