/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.shell.command;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.SystemUtils;
import org.apache.nifi.diagnostics.bootstrap.shell.command.PlatformShellCommand;
import org.apache.nifi.diagnostics.bootstrap.shell.result.ShellCommandResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShellCommand
implements PlatformShellCommand {
    private static final Logger logger = LoggerFactory.getLogger(AbstractShellCommand.class);
    private final String name;
    private final String[] windowsCommand;
    private final String[] linuxCommand;
    private final String[] macCommand;
    private final ShellCommandResult result;

    public AbstractShellCommand(String name, String[] windowsCommand, String[] linuxCommand, String[] macCommand, ShellCommandResult result) {
        this.name = name;
        this.windowsCommand = windowsCommand;
        this.linuxCommand = linuxCommand;
        this.macCommand = macCommand;
        this.result = result;
    }

    public String getName() {
        return this.name;
    }

    public String[] getCommand() {
        if (SystemUtils.IS_OS_MAC) {
            return this.macCommand;
        }
        if (SystemUtils.IS_OS_UNIX || SystemUtils.IS_OS_LINUX) {
            return this.linuxCommand;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.windowsCommand;
        }
        throw new UnsupportedOperationException("Operating system not supported.");
    }

    @Override
    public Collection<String> execute() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.getCommand());
        try {
            Process process = processBuilder.start();
            return this.result.createResult(process.getInputStream());
        }
        catch (UnsupportedOperationException e) {
            logger.warn(String.format("Operating system is not supported, failed to execute command: %s, ", this.name));
            return Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to execute command: %s", this.name), e);
        }
    }
}

