/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractSplitVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.SimpleMapValuePeeker;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

public class SampleByFillValueNotKeyedRecordCursor
extends AbstractSplitVirtualRecordSampleByCursor {
    private final SimpleMapValuePeeker peeker;
    private final SimpleMapValue simpleMapValue;
    private boolean gapFill = false;

    public SampleByFillValueNotKeyedRecordCursor(ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, ObjList<Function> recordFunctions, ObjList<Function> placeholderFunctions, SimpleMapValuePeeker peeker, int timestampIndex, TimestampSampler timestampSampler, SimpleMapValue simpleMapValue, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions, groupByFunctionsUpdater, placeholderFunctions, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        this.simpleMapValue = simpleMapValue;
        this.record.of(simpleMapValue);
        this.peeker = peeker;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        if (this.baseRecord == null && !this.gapFill) {
            return false;
        }
        long expectedLocalEpoch = this.timestampSampler.nextTimestamp(this.nextSampleLocalEpoch);
        if (expectedLocalEpoch < this.localEpoch) {
            this.setActiveB(expectedLocalEpoch);
            this.sampleLocalEpoch = expectedLocalEpoch;
            this.nextSampleLocalEpoch = expectedLocalEpoch;
            return true;
        }
        if (this.setActiveA(expectedLocalEpoch)) {
            return this.peeker.reset();
        }
        return this.notKeyedLoop(this.simpleMapValue);
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
        }
    }

    private boolean setActiveA(long expectedLocalEpoch) {
        if (this.gapFill) {
            this.gapFill = false;
            this.record.setActiveA();
            this.sampleLocalEpoch = expectedLocalEpoch;
            this.nextSampleLocalEpoch = expectedLocalEpoch;
            return true;
        }
        return false;
    }

    private void setActiveB(long expectedLocalEpoch) {
        if (!this.gapFill) {
            this.record.setActiveB(this.sampleLocalEpoch, expectedLocalEpoch, this.localEpoch);
            this.record.setTarget(this.peeker.peek());
            this.gapFill = true;
        }
    }
}

