/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.AbstractLockable;
import io.questdb.std.Mutable;
import io.questdb.std.Rosti;
import io.questdb.std.RostiAllocFacade;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class VectorAggregateEntry
extends AbstractLockable
implements Mutable {
    private ExecutionCircuitBreaker circuitBreaker;
    private int columnSizeShr;
    private CountDownLatchSPI doneLatch;
    private VectorAggregateFunction func;
    private long keyAddress;
    private AtomicInteger oomCounter;
    private long[] pRosti;
    private RostiAllocFacade raf;
    private long valueAddress;
    private long valueCount;

    @Override
    public void clear() {
        this.valueAddress = 0L;
        this.valueCount = 0L;
        this.func = null;
    }

    public boolean run(int workerId) {
        if (this.tryLock()) {
            if (!(this.circuitBreaker.checkIfTripped() || this.oomCounter != null && this.oomCounter.get() != 0)) {
                if (this.pRosti != null) {
                    long oldSize = Rosti.getAllocMemory(this.pRosti[workerId]);
                    if (!this.func.aggregate(this.pRosti[workerId], this.keyAddress, this.valueAddress, this.valueCount, this.columnSizeShr, workerId)) {
                        this.oomCounter.incrementAndGet();
                    }
                    this.raf.updateMemoryUsage(this.pRosti[workerId], oldSize);
                } else {
                    this.func.aggregate(this.valueAddress, this.valueCount, this.columnSizeShr, workerId);
                }
            }
            this.doneLatch.countDown();
            return true;
        }
        return false;
    }

    void of(int sequence, VectorAggregateFunction vaf, long[] pRosti, long keyPageAddress, long valuePageAddress, long valuePageCount, int columnSizeShr, CountDownLatchSPI doneLatch, @Nullable AtomicInteger oomCounter, RostiAllocFacade raf, ExecutionCircuitBreaker circuitBreaker) {
        this.of(sequence);
        this.pRosti = pRosti;
        this.keyAddress = keyPageAddress;
        this.valueAddress = valuePageAddress;
        this.valueCount = valuePageCount;
        this.func = vaf;
        this.columnSizeShr = columnSizeShr;
        this.doneLatch = doneLatch;
        this.oomCounter = oomCounter;
        this.raf = raf;
        this.circuitBreaker = circuitBreaker;
    }
}

