/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class HashOuterJoinFilteredLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final HashOuterJoinLightRecordCursor cursor;
    private final Function filter;
    private final JoinContext joinContext;
    private final RecordCursorFactory masterFactory;
    private final RecordSink masterKeySink;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink slaveKeySink;

    public HashOuterJoinFilteredLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, @NotNull Function filter, JoinContext joinContext) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashOuterJoinLightRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), joinColumnTypes, valueTypes, configuration);
        this.filter = filter;
        this.joinContext = joinContext;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        try {
            this.cursor.of(slaveCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(this.cursor);
            throw e;
        }
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Outer Join Light");
        sink.optAttr((CharSequence)"condition", this.joinContext);
        sink.attr("filter").val(this.filter);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
        this.filter.close();
    }

    private class HashOuterJoinLightRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final OuterJoinRecord record;
        private final LongChain slaveChain;
        private boolean isOpen;
        private Record masterRecord;
        private LongChain.TreeCursor slaveChainCursor;
        private Record slaveRecord;

        public HashOuterJoinLightRecordCursor(int columnSplit, Record nullRecord, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, CairoConfiguration configuration) {
            super(columnSplit);
            this.joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
            this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.record.hasSlave(true);
                while (this.slaveChainCursor.hasNext()) {
                    this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                    if (HashOuterJoinFilteredLightRecordCursorFactory.this.filter.getBool(this.record)) {
                        return true;
                    }
                    this.slaveChainCursor.next();
                }
            }
            if (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashOuterJoinFilteredLightRecordCursorFactory.this.masterKeySink);
                MapValue value = key.findValue();
                if (value != null) {
                    this.slaveChainCursor = this.slaveChain.getCursor(value.getLong(0));
                    this.record.hasSlave(true);
                    while (this.slaveChainCursor.hasNext()) {
                        this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                        if (!HashOuterJoinFilteredLightRecordCursorFactory.this.filter.getBool(this.record)) continue;
                        return true;
                    }
                }
                this.slaveChainCursor = null;
                this.record.hasSlave(false);
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
            HashOuterJoinFilteredLightRecordCursorFactory.this.filter.toTop();
        }

        private void buildMapOfSlaveRecords(RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            Record record = slaveCursor.getRecord();
            while (slaveCursor.hasNext()) {
                circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.joinKeyMap.withKey();
                key.put(record, HashOuterJoinFilteredLightRecordCursorFactory.this.slaveKeySink);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    long offset = this.slaveChain.put(record.getRowId(), -1L);
                    value.putLong(0, offset);
                    value.putLong(1, offset);
                    continue;
                }
                value.putLong(1, this.slaveChain.put(record.getRowId(), value.getLong(1)));
            }
        }

        void of(RecordCursor slaveCursor, SqlExecutionContext executionContext) throws SqlException {
            this.slaveCursor = slaveCursor;
            if (!this.isOpen) {
                this.isOpen = true;
                this.slaveChain.reopen();
                this.joinKeyMap.reopen();
            }
            this.buildMapOfSlaveRecords(slaveCursor, executionContext.getCircuitBreaker());
            this.masterCursor = HashOuterJoinFilteredLightRecordCursorFactory.this.masterFactory.getCursor(executionContext);
            this.masterRecord = this.masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.slaveChainCursor = null;
        }
    }
}

