/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;

public final class StandardContentClaim
implements ContentClaim,
Comparable<ContentClaim> {
    private final ResourceClaim resourceClaim;
    private final long offset;
    private volatile long length;

    public StandardContentClaim(ResourceClaim resourceClaim, long offset) {
        this.resourceClaim = resourceClaim;
        this.offset = offset;
        this.length = -1L;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.resourceClaim == null ? 0 : this.resourceClaim.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentClaim)) {
            return false;
        }
        ContentClaim other = (ContentClaim)obj;
        if (this.offset != other.getOffset()) {
            return false;
        }
        if (this.length != other.getLength()) {
            return false;
        }
        return this.resourceClaim.equals(other.getResourceClaim());
    }

    @Override
    public int compareTo(ContentClaim o) {
        int resourceComp = this.resourceClaim.compareTo(o.getResourceClaim());
        if (resourceComp != 0) {
            return resourceComp;
        }
        return Long.compare(this.offset, o.getOffset());
    }

    public ResourceClaim getResourceClaim() {
        return this.resourceClaim;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return "StandardContentClaim [resourceClaim=" + this.resourceClaim + ", offset=" + this.offset + ", length=" + this.length + "]";
    }
}

