/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.util.PropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessPolicyProviderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessPolicyProviderUtils.class);
    public static final String PROP_NIFI_IDENTITY_PREFIX = "NiFi Identity ";
    public static final String PROP_INITIAL_ADMIN_IDENTITY = "Initial Admin Identity";
    public static final Pattern NIFI_IDENTITY_PATTERN = Pattern.compile("NiFi Identity \\S+");
    public static final String PROP_NIFI_GROUP_NAME = "NiFi Group Name";

    public static String getInitialAdminIdentity(AuthorizerConfigurationContext configurationContext, IdentityMapper identityMapper) {
        PropertyValue initialAdminIdentityProp = configurationContext.getProperty(PROP_INITIAL_ADMIN_IDENTITY);
        return initialAdminIdentityProp.isSet() ? identityMapper.mapUser(initialAdminIdentityProp.getValue()) : null;
    }

    public static Set<String> getNiFiIdentities(AuthorizerConfigurationContext configurationContext, IdentityMapper identityMapper) {
        HashSet<String> nifiIdentities = new HashSet<String>();
        for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
            Matcher matcher = NIFI_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            nifiIdentities.add(identityMapper.mapUser((String)entry.getValue()));
        }
        return nifiIdentities;
    }

    public static String getNiFiGroupName(AuthorizerConfigurationContext configurationContext, IdentityMapper identityMapper) {
        String nifiGroupName;
        PropertyValue nifiGroupNameProp = configurationContext.getProperty(PROP_NIFI_GROUP_NAME);
        String string = nifiGroupName = nifiGroupNameProp != null && nifiGroupNameProp.isSet() ? nifiGroupNameProp.getValue() : null;
        if (StringUtils.isBlank(nifiGroupName)) {
            LOGGER.debug("NiFi Group Name was not specified");
            return null;
        }
        return identityMapper.mapGroup(nifiGroupName);
    }

    public static Group getGroup(String groupName, UserGroupProvider userGroupProvider) {
        Set groups = userGroupProvider.getGroups();
        LOGGER.trace("All groups: {}", (Object)groups);
        Optional<Group> groupOptional = groups.stream().filter(group -> group.getName().equals(groupName)).findFirst();
        Group group2 = groupOptional.orElseThrow(() -> new SecurityProviderCreationException(String.format("Group '%s' could not be found", groupName)));
        LOGGER.debug("Group identifier is: {}", (Object)group2);
        return group2;
    }

    private AccessPolicyProviderUtils() {
    }
}

