/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.security.util.KeystoreType;

public interface TlsConfiguration {
    public static final String SSL_PROTOCOL = "SSL";
    public static final String TLS_PROTOCOL = "TLS";
    public static final String TLS_1_0_PROTOCOL = "TLSv1";
    public static final String TLS_1_1_PROTOCOL = "TLSv1.1";
    public static final String TLS_1_2_PROTOCOL = "TLSv1.2";
    public static final String[] LEGACY_TLS_PROTOCOL_VERSIONS = new String[]{"TLSv1", "TLSv1.1"};
    public static final String JAVA_8_MAX_SUPPORTED_TLS_PROTOCOL_VERSION = "TLSv1.2";
    public static final String JAVA_11_MAX_SUPPORTED_TLS_PROTOCOL_VERSION = "TLSv1.3";
    public static final String[] JAVA_8_SUPPORTED_TLS_PROTOCOL_VERSIONS = new String[]{"TLSv1.2"};
    public static final String[] JAVA_11_SUPPORTED_TLS_PROTOCOL_VERSIONS = new String[]{"TLSv1.3", "TLSv1.2"};

    public static boolean isEmpty(TlsConfiguration tlsConfiguration) {
        return tlsConfiguration == null || !tlsConfiguration.isAnyKeystorePopulated() && !tlsConfiguration.isAnyTruststorePopulated();
    }

    public String getKeystorePath();

    public String getKeystorePassword();

    public String getKeystorePasswordForLogging();

    public String getKeyPassword();

    public String getKeyPasswordForLogging();

    public String getFunctionalKeyPassword();

    public String getFunctionalKeyPasswordForLogging();

    public KeystoreType getKeystoreType();

    public String getTruststorePath();

    public String getTruststorePassword();

    public String getTruststorePasswordForLogging();

    public KeystoreType getTruststoreType();

    public String getProtocol();

    public boolean isKeystorePopulated();

    public boolean isAnyKeystorePopulated();

    public boolean isKeystoreValid();

    public boolean isTruststorePopulated();

    public boolean isAnyTruststorePopulated();

    public boolean isTruststoreValid();

    public String[] getKeystorePropertiesForLogging();

    public String[] getTruststorePropertiesForLogging();

    public String[] getEnabledProtocols();

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        return TlsConfiguration.parseJavaVersion(version);
    }

    public static int parseJavaVersion(String version) {
        String majorVersion;
        if (version.startsWith("1.")) {
            majorVersion = version.substring(2, 3);
        } else {
            Pattern majorVersion9PlusPattern = Pattern.compile("(\\d+).*");
            Matcher m = majorVersion9PlusPattern.matcher(version);
            if (m.find()) {
                majorVersion = m.group(1);
            } else {
                throw new IllegalArgumentException("Could not detect major version of " + version);
            }
        }
        return Integer.parseInt(majorVersion);
    }

    public static String[] getCurrentSupportedTlsProtocolVersions() {
        int javaMajorVersion = TlsConfiguration.getJavaVersion();
        if (javaMajorVersion < 11) {
            return JAVA_8_SUPPORTED_TLS_PROTOCOL_VERSIONS;
        }
        return JAVA_11_SUPPORTED_TLS_PROTOCOL_VERSIONS;
    }

    public static String getHighestCurrentSupportedTlsProtocolVersion() {
        int javaMajorVersion = TlsConfiguration.getJavaVersion();
        if (javaMajorVersion < 11) {
            return "TLSv1.2";
        }
        return JAVA_11_MAX_SUPPORTED_TLS_PROTOCOL_VERSION;
    }
}

