/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.SecretProperties;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SecretRequestAttributes
implements JsonSerializable<SecretRequestAttributes> {
    private String value;
    private String id;
    private Boolean enabled;
    private Long notBefore;
    private Long expires;
    private Long created;
    private Long updated;

    public SecretRequestAttributes(SecretProperties secretProperties) {
        if (secretProperties.getNotBefore() != null) {
            this.notBefore = secretProperties.getNotBefore().toEpochSecond();
        }
        if (secretProperties.getExpiresOn() != null) {
            this.expires = secretProperties.getExpiresOn().toEpochSecond();
        }
        this.enabled = secretProperties.isEnabled();
    }

    private SecretRequestAttributes() {
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public SecretRequestAttributes getEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.notBefore * 1000L), ZoneOffset.UTC);
    }

    public SecretRequestAttributes setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(OffsetDateTime.ofInstant(notBefore.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    public OffsetDateTime getExpires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.expires * 1000L), ZoneOffset.UTC);
    }

    public SecretRequestAttributes setExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(OffsetDateTime.ofInstant(expires.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.created * 1000L), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.updated * 1000L), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("value", this.value).writeStringField("id", this.id).writeBooleanField("enabled", this.enabled).writeNumberField("nbf", (Number)this.notBefore).writeNumberField("exp", (Number)this.expires).writeEndObject();
    }

    public static SecretRequestAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (SecretRequestAttributes)jsonReader.readObject(reader -> {
            SecretRequestAttributes attributes = new SecretRequestAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    attributes.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    attributes.id = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    attributes.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    attributes.notBefore = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    attributes.expires = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    attributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    attributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return attributes;
        });
    }
}

