/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.s2s;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransactionCompletion;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.remote.protocol.DataPacket;

public class SiteToSiteReceiver {
    private final SiteToSiteClient siteToSiteClient;
    private final OutputStream output;

    public SiteToSiteReceiver(SiteToSiteClient siteToSiteClient, OutputStream output) {
        this.siteToSiteClient = siteToSiteClient;
        this.output = output;
    }

    public TransactionCompletion receiveFiles() throws IOException {
        DataPacket dataPacket;
        Transaction transaction = this.siteToSiteClient.createTransaction(TransferDirection.RECEIVE);
        JsonGenerator jsonGenerator = new JsonFactory().createJsonGenerator(this.output);
        jsonGenerator.writeStartArray();
        while ((dataPacket = transaction.receive()) != null) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("attributes");
            jsonGenerator.writeStartObject();
            Map attributes = dataPacket.getAttributes();
            if (attributes != null) {
                for (Map.Entry stringStringEntry : attributes.entrySet()) {
                    jsonGenerator.writeStringField((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue());
                }
            }
            jsonGenerator.writeEndObject();
            InputStream data = dataPacket.getData();
            if (data != null) {
                jsonGenerator.writeBinaryField("data", IOUtils.toByteArray((InputStream)data));
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.close();
        transaction.confirm();
        return transaction.complete();
    }
}

