/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.stream.io.StreamThrottler;

public class LeakyBucketStreamThrottler
implements StreamThrottler {
    private final int maxBytesPerSecond;
    private final BlockingQueue<Request> requestQueue = new LinkedBlockingQueue<Request>();
    private final ScheduledExecutorService executorService;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public LeakyBucketStreamThrottler(int maxBytesPerSecond) {
        this.maxBytesPerSecond = maxBytesPerSecond;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        Drain task = new Drain();
        this.executorService.scheduleAtFixedRate(task, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.shutdown.set(true);
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public OutputStream newThrottledOutputStream(final OutputStream toWrap) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(b, off, len);
                LeakyBucketStreamThrottler.this.copy(in, toWrap);
            }

            @Override
            public void close() throws IOException {
                toWrap.close();
            }

            @Override
            public void flush() throws IOException {
                toWrap.flush();
            }
        };
    }

    @Override
    public InputStream newThrottledInputStream(final InputStream toWrap) {
        return new InputStream(){
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();

            @Override
            public int read() throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1);
                LeakyBucketStreamThrottler.this.copy(toWrap, baos, 1L);
                if (baos.size() < 1) {
                    return -1;
                }
                return baos.toByteArray()[0] & 0xFF;
            }

            @Override
            public int read(byte[] b) throws IOException {
                if (b.length == 0) {
                    return 0;
                }
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (len < 0) {
                    throw new IllegalArgumentException();
                }
                if (len == 0) {
                    return 0;
                }
                this.baos.reset();
                int copied = (int)LeakyBucketStreamThrottler.this.copy(toWrap, this.baos, len);
                if (copied == 0) {
                    return -1;
                }
                System.arraycopy(this.baos.toByteArray(), 0, b, off, copied);
                return copied;
            }

            @Override
            public void close() throws IOException {
                toWrap.close();
            }

            @Override
            public int available() throws IOException {
                return toWrap.available();
            }
        };
    }

    @Override
    public long copy(InputStream in, OutputStream out) throws IOException {
        return this.copy(in, out, -1L);
    }

    @Override
    public long copy(InputStream in, OutputStream out, long maxBytes) throws IOException {
        long totalBytesCopied = 0L;
        boolean finished = false;
        while (!finished) {
            long requestMax = maxBytes < 0L ? Long.MAX_VALUE : maxBytes - totalBytesCopied;
            Request request = new Request(in, out, requestMax);
            boolean transferred = false;
            while (!transferred) {
                if (this.shutdown.get()) {
                    throw new IOException("Throttler shutdown");
                }
                try {
                    transferred = this.requestQueue.offer(request, 1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted", e);
                }
            }
            BlockingQueue<Response> responseQueue = request.getResponseQueue();
            Response response = null;
            while (response == null) {
                try {
                    if (this.shutdown.get()) {
                        throw new IOException("Throttler shutdown");
                    }
                    response = responseQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted", e);
                }
            }
            if (!response.isSuccess()) {
                throw response.getError();
            }
            finished = response.getBytesCopied() == 0 || (totalBytesCopied += (long)response.getBytesCopied()) >= maxBytes && maxBytes > 0L;
        }
        return totalBytesCopied;
    }

    private class Drain
    implements Runnable {
        private final byte[] buffer;

        public Drain() {
            int bufferSize = Math.min(4096, LeakyBucketStreamThrottler.this.maxBytesPerSecond);
            this.buffer = new byte[bufferSize];
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int bytesTransferred = 0;
            while (bytesTransferred < LeakyBucketStreamThrottler.this.maxBytesPerSecond) {
                long maxMillisToWait = 1000L - (System.currentTimeMillis() - start);
                if (maxMillisToWait < 1L) {
                    return;
                }
                try {
                    Request request = LeakyBucketStreamThrottler.this.requestQueue.poll(maxMillisToWait, TimeUnit.MILLISECONDS);
                    if (request == null) {
                        return;
                    }
                    BlockingQueue<Response> responseQueue = request.getResponseQueue();
                    OutputStream out = request.getOutputStream();
                    InputStream in = request.getInputStream();
                    try {
                        long requestMax = request.getMaxBytesToCopy();
                        long maxBytesToTransfer = requestMax < 0L ? (long)Math.min(this.buffer.length, LeakyBucketStreamThrottler.this.maxBytesPerSecond - bytesTransferred) : Math.min(requestMax, (long)Math.min(this.buffer.length, LeakyBucketStreamThrottler.this.maxBytesPerSecond - bytesTransferred));
                        maxBytesToTransfer = Math.max(1L, maxBytesToTransfer);
                        int bytesCopied = this.fillBuffer(in, maxBytesToTransfer);
                        out.write(this.buffer, 0, bytesCopied);
                        Response response = new Response(true, bytesCopied);
                        responseQueue.put(response);
                        bytesTransferred += bytesCopied;
                    }
                    catch (IOException e) {
                        Response response = new Response(e);
                        responseQueue.put(response);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private int fillBuffer(InputStream in, long maxBytes) throws IOException {
            int len;
            int bytesRead = 0;
            while ((long)bytesRead < maxBytes && (len = in.read(this.buffer, bytesRead, (int)Math.min(maxBytes - (long)bytesRead, (long)(this.buffer.length - bytesRead)))) > 0) {
                bytesRead += len;
            }
            return bytesRead;
        }
    }

    private static class Request {
        private final OutputStream out;
        private final InputStream in;
        private final long maxBytesToCopy;
        private final BlockingQueue<Response> responseQueue;

        public Request(InputStream in, OutputStream out, long maxBytesToCopy) {
            this.out = out;
            this.in = in;
            this.maxBytesToCopy = maxBytesToCopy;
            this.responseQueue = new LinkedBlockingQueue<Response>(1);
        }

        public BlockingQueue<Response> getResponseQueue() {
            return this.responseQueue;
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public long getMaxBytesToCopy() {
            return this.maxBytesToCopy;
        }

        public String toString() {
            return "Request[maxBytes=" + this.maxBytesToCopy + "]";
        }
    }

    private static class Response {
        private final boolean success;
        private final IOException error;
        private final int bytesCopied;

        public Response(boolean success, int bytesCopied) {
            this.success = success;
            this.bytesCopied = bytesCopied;
            this.error = null;
        }

        public Response(IOException error) {
            this.success = false;
            this.error = error;
            this.bytesCopied = -1;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public IOException getError() {
            return this.error;
        }

        public int getBytesCopied() {
            return this.bytesCopied;
        }
    }
}

