/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name="portStatusSnapshot")
public class PortStatusSnapshotDTO
implements Cloneable {
    private String id;
    private String groupId;
    private String name;
    private Integer activeThreadCount = 0;
    private Integer flowFilesIn = 0;
    private Long bytesIn = 0L;
    private String input;
    private Integer flowFilesOut = 0;
    private Long bytesOut = 0L;
    private String output;
    private Boolean transmitting;
    private String runStatus;

    @Schema(description="Whether the port has incoming or outgoing connections to a remote NiFi.")
    public Boolean isTransmitting() {
        return this.transmitting;
    }

    public void setTransmitting(Boolean transmitting) {
        this.transmitting = transmitting;
    }

    @Schema(description="The active thread count for the port.")
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    @Schema(description="The id of the port.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The id of the parent process group of the port.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The name of the port.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The run status of the port.", allowableValues={"Running, Stopped, Validating, Disabled, Invalid"})
    public String getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    @Schema(description="The count/size of flowfiles that have been accepted in the last 5 minutes.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    @Schema(description="The count/size of flowfiles that have been processed in the last 5 minutes.")
    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @Schema(description="The number of FlowFiles that have been accepted in the last 5 minutes.")
    public Integer getFlowFilesIn() {
        return this.flowFilesIn;
    }

    public void setFlowFilesIn(Integer flowFilesIn) {
        this.flowFilesIn = flowFilesIn;
    }

    @Schema(description="The size of hte FlowFiles that have been accepted in the last 5 minutes.")
    public Long getBytesIn() {
        return this.bytesIn;
    }

    public void setBytesIn(Long bytesIn) {
        this.bytesIn = bytesIn;
    }

    @Schema(description="The number of FlowFiles that have been processed in the last 5 minutes.")
    public Integer getFlowFilesOut() {
        return this.flowFilesOut;
    }

    public void setFlowFilesOut(Integer flowFilesOut) {
        this.flowFilesOut = flowFilesOut;
    }

    @Schema(description="The number of bytes that have been processed in the last 5 minutes.")
    public Long getBytesOut() {
        return this.bytesOut;
    }

    public void setBytesOut(Long bytesOut) {
        this.bytesOut = bytesOut;
    }

    public PortStatusSnapshotDTO clone() {
        PortStatusSnapshotDTO other = new PortStatusSnapshotDTO();
        other.setId(this.getId());
        other.setGroupId(this.getGroupId());
        other.setName(this.getName());
        other.setActiveThreadCount(this.getActiveThreadCount());
        other.setFlowFilesIn(this.getFlowFilesIn());
        other.setBytesIn(this.getBytesIn());
        other.setFlowFilesOut(this.getFlowFilesOut());
        other.setBytesOut(this.getBytesOut());
        other.setTransmitting(this.isTransmitting());
        other.setRunStatus(this.getRunStatus());
        other.setInput(this.getInput());
        other.setOutput(this.getOutput());
        return other;
    }
}

