/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.KeyStoreBuilder;

public class EphemeralKeyStoreBuilder
implements KeyStoreBuilder {
    private static final String CERTIFICATE_ALIAS = "certificate-%d";
    private static final String PRIVATE_KEY_ALIAS = "private-key-%d";
    private final List<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private final List<KeyStore.PrivateKeyEntry> privateKeyEntries = new ArrayList<KeyStore.PrivateKeyEntry>();
    private char[] keyPassword = null;

    public EphemeralKeyStoreBuilder addCertificate(X509Certificate certificate) {
        Objects.requireNonNull(certificate, "Certificate required");
        this.certificates.add(certificate);
        return this;
    }

    public EphemeralKeyStoreBuilder addPrivateKeyEntry(KeyStore.PrivateKeyEntry privateKeyEntry) {
        Objects.requireNonNull(privateKeyEntry, "Private Key Entry required");
        this.privateKeyEntries.add(privateKeyEntry);
        return this;
    }

    public EphemeralKeyStoreBuilder keyPassword(char[] keyPassword) {
        this.keyPassword = (char[])Objects.requireNonNull(keyPassword, "Key Password required").clone();
        return this;
    }

    @Override
    public KeyStore build() {
        KeyStore keyStore = this.getInitializedKeyStore();
        ListIterator<X509Certificate> certificateEntries = this.certificates.listIterator();
        while (certificateEntries.hasNext()) {
            String alias = CERTIFICATE_ALIAS.formatted(certificateEntries.nextIndex());
            X509Certificate certificate = certificateEntries.next();
            try {
                keyStore.setCertificateEntry(alias, certificate);
            }
            catch (KeyStoreException e) {
                String message = String.format("Set certificate entry [%s] failed", alias);
                throw new BuilderConfigurationException(message, e);
            }
        }
        ListIterator<KeyStore.PrivateKeyEntry> privateKeys = this.privateKeyEntries.listIterator();
        while (privateKeys.hasNext()) {
            String alias = PRIVATE_KEY_ALIAS.formatted(privateKeys.nextIndex());
            KeyStore.PrivateKeyEntry privateKeyEntry = privateKeys.next();
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Certificate[] certificateChain = privateKeyEntry.getCertificateChain();
            try {
                keyStore.setKeyEntry(alias, privateKey, this.keyPassword, certificateChain);
            }
            catch (KeyStoreException e) {
                String message = String.format("Set key entry [%s] failed", alias);
                throw new BuilderConfigurationException(message, e);
            }
        }
        return keyStore;
    }

    private KeyStore getInitializedKeyStore() {
        String keyStoreType = KeyStore.getDefaultType();
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null);
            return keyStore;
        }
        catch (Exception e) {
            String message = String.format("Key Store Type [%s] initialization failed", keyStoreType);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

