/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name="connectable")
public class ConnectableDTO {
    private String id;
    private String versionedComponentId;
    private String type;
    private String groupId;
    private String name;
    private Boolean running;
    private Boolean transmitting;
    private Boolean exists;
    private String comments;

    @Schema(description="The id of the connectable component.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The ID of the corresponding component that is under version control")
    public String getVersionedComponentId() {
        return this.versionedComponentId;
    }

    public void setVersionedComponentId(String id) {
        this.versionedComponentId = id;
    }

    @Schema(description="The type of component the connectable is.", requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"PROCESSOR, REMOTE_INPUT_PORT, REMOTE_OUTPUT_PORT, INPUT_PORT, OUTPUT_PORT, FUNNEL"})
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Schema(description="The id of the group that the connectable component resides in", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The name of the connectable component")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="Reflects the current state of the connectable component.")
    public Boolean isRunning() {
        return this.running;
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    @Schema(description="If the connectable component represents a remote port, indicates if the target exists.")
    public Boolean getExists() {
        return this.exists;
    }

    public void setExists(Boolean exists) {
        this.exists = exists;
    }

    @Schema(description="If the connectable component represents a remote port, indicates if the target is configured to transmit.")
    public Boolean getTransmitting() {
        return this.transmitting;
    }

    public void setTransmitting(Boolean transmitting) {
        this.transmitting = transmitting;
    }

    @Schema(description="The comments for the connectable component.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String toString() {
        return "ConnectableDTO [Id=" + this.id + "]";
    }
}

