/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class PGExport
extends AbstractNiFiCommand<VoidResult> {
    public PGExport() {
        super("pg-export", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Exports a given process group to a json representation, with or without the referenced services from outside the target group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.OUTPUT_FILE.createOption());
        this.addOption(CommandOption.INCLUDE_REFERENCED_SERVICES.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String id = this.getRequiredArg(properties, CommandOption.PG_ID);
        boolean includeReferencedServices = this.getArg(properties, CommandOption.INCLUDE_REFERENCED_SERVICES) == null ? Boolean.FALSE : Boolean.TRUE;
        File outputFile = new File(this.getRequiredArg(properties, CommandOption.OUTPUT_FILE));
        ProcessGroupClient processGroupClient = client.getProcessGroupClient();
        processGroupClient.exportProcessGroup(id, includeReferencedServices, outputFile);
        return VoidResult.getInstance();
    }
}

