/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManager$ {
    public static DelegationTokenManager$ MODULE$;
    private final String DefaultHmacAlgorithm;
    private final int CurrentVersion;
    private final int ErrorTimestamp;

    static {
        new DelegationTokenManager$();
    }

    public String DefaultHmacAlgorithm() {
        return this.DefaultHmacAlgorithm;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public int ErrorTimestamp() {
        return this.ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
    }

    public boolean filterToken(KafkaPrincipal requesterPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken, Function1<KafkaPrincipal, Object> authorizeRequester) {
        if (owners.isDefined() && !((LinearSeqOptimized)owners.get()).exists((Function1 & java.io.Serializable & Serializable)owner -> BoxesRunTime.boxToBoolean((boolean)token.ownerOrRenewer(owner)))) {
            return false;
        }
        if (token.ownerOrRenewer(requesterPrincipal)) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)authorizeToken.apply((Object)token.tokenId())) || BoxesRunTime.unboxToBoolean((Object)authorizeRequester.apply((Object)token.owner()));
    }

    private DelegationTokenManager$() {
        MODULE$ = this;
        this.DefaultHmacAlgorithm = "HmacSHA512";
        this.CurrentVersion = 3;
        this.ErrorTimestamp = -1;
    }
}

