/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.orphan;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.scoring.AbstractScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanScoringFilter
extends AbstractScoringFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OrphanScoringFilter.class);
    public static Text ORPHAN_KEY_WRITABLE = new Text("_orphan_");
    private static int DEFAULT_GONE_TIME = 2592000;
    private static int DEFAULT_ORPHAN_TIME = 3456000;
    private long markGoneAfter = DEFAULT_GONE_TIME;
    private long markOrphanAfter = DEFAULT_ORPHAN_TIME;

    public void setConf(Configuration conf) {
        this.markGoneAfter = conf.getInt("scoring.orphan.mark.gone.after", DEFAULT_GONE_TIME);
        this.markOrphanAfter = conf.getInt("scoring.orphan.mark.orphan.after", DEFAULT_ORPHAN_TIME);
        if (this.markGoneAfter > this.markOrphanAfter) {
            LOG.warn("OrphanScoringFilter: the time span after which pages are marked as gone is larger than that to mark pages as orphaned (scoring.orphan.mark.gone.after > scoring.orphan.mark.orphan.after): This disables marking pages as gone.");
        }
    }

    public void updateDbScore(Text url, CrawlDatum old, CrawlDatum datum, List<CrawlDatum> inlinks) throws ScoringFilterException {
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (inlinks.size() > 0) {
            datum.getMetaData().put((Writable)ORPHAN_KEY_WRITABLE, (Writable)new IntWritable(now));
        } else {
            this.orphanedScore(url, datum);
        }
    }

    public void orphanedScore(Text url, CrawlDatum datum) {
        if (datum.getMetaData().containsKey((Object)ORPHAN_KEY_WRITABLE)) {
            IntWritable writable = (IntWritable)datum.getMetaData().get((Object)ORPHAN_KEY_WRITABLE);
            int lastInlinkTime = writable.get();
            int now = (int)(System.currentTimeMillis() / 1000L);
            int elapsedSinceLastInLinkTime = now - lastInlinkTime;
            if ((long)elapsedSinceLastInLinkTime > this.markOrphanAfter) {
                datum.setStatus(8);
            } else if ((long)elapsedSinceLastInLinkTime > this.markGoneAfter) {
                datum.setStatus(3);
            }
        }
    }
}

