/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.FactoryUDT;
import com.barchart.udt.LingerUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.util.HelpUDT;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionUDT<T> {
    public static final OptionUDT<Integer> UDT_MSS;
    public static final OptionUDT<Integer> Maximum_Transfer_Unit;
    public static final OptionUDT<Boolean> UDT_SNDSYN;
    public static final OptionUDT<Boolean> Is_Send_Synchronous;
    public static final OptionUDT<Boolean> UDT_RCVSYN;
    public static final OptionUDT<Boolean> Is_Receive_Synchronous;
    public static final OptionUDT<FactoryUDT> UDT_CC;
    public static final OptionUDT<FactoryUDT> Custom_Congestion_Control;
    public static final OptionUDT<Integer> UDT_FC;
    public static final OptionUDT<Integer> Flight_Window_Size;
    public static final OptionUDT<Integer> UDT_SNDBUF;
    public static final OptionUDT<Integer> Protocol_Send_Buffer_Size;
    public static final OptionUDT<Integer> UDT_RCVBUF;
    public static final OptionUDT<Integer> Protocol_Receive_Buffer_Size;
    public static final OptionUDT<LingerUDT> UDT_LINGER;
    public static final OptionUDT<LingerUDT> Time_To_Linger_On_Close;
    public static final OptionUDT<Integer> UDP_SNDBUF;
    public static final OptionUDT<Integer> System_Send_Buffer_Size;
    public static final OptionUDT<Integer> UDP_RCVBUF;
    public static final OptionUDT<Integer> System_Receive_Buffer_Size;
    public static final OptionUDT<Boolean> UDT_RENDEZVOUS;
    public static final OptionUDT<Boolean> Is_Randezvous_Connect_Enabled;
    public static final OptionUDT<Integer> UDT_SNDTIMEO;
    public static final OptionUDT<Integer> Send_Timeout;
    public static final OptionUDT<Integer> UDT_RCVTIMEO;
    public static final OptionUDT<Integer> Receive_Timeout;
    public static final OptionUDT<Boolean> UDT_REUSEADDR;
    public static final OptionUDT<Boolean> Is_Address_Reuse_Enabled;
    public static final OptionUDT<Long> UDT_MAXBW;
    public static final OptionUDT<Long> Maximum_Bandwidth;
    public static final OptionUDT<Integer> UDT_STATE;
    public static final OptionUDT<Integer> Status_Code;
    public static final OptionUDT<Integer> UDT_EVENT;
    public static final OptionUDT<Integer> Epoll_Event_Mask;
    public static final OptionUDT<Integer> UDT_SNDDATA;
    public static final OptionUDT<Integer> Send_Buffer_Consumed;
    public static final OptionUDT<Integer> UDT_RCVDATA;
    public static final OptionUDT<Integer> Receive_Buffer_Available;
    protected static final Logger log;
    protected static final List<OptionUDT<?>> values;
    private final int code;
    private final Class<?> type;
    private final Format format;
    private String name;

    protected OptionUDT(int code, Class<T> klaz, Format format) {
        this.code = code;
        this.type = klaz;
        this.format = format;
        values.add(this);
    }

    protected static <T> OptionUDT<T> NEW(int code, Class<T> klaz, Format format) {
        return new OptionUDT<T>(code, klaz, format);
    }

    public static void appendSnapshot(SocketUDT socketUDT, StringBuilder text) {
        text.append("\n\t");
        text.append(String.format("[id: 0x%08x]", socketUDT.id()));
        for (OptionUDT<?> option : values) {
            int optionCode = 0;
            String optionName = null;
            String optionValue = null;
            try {
                optionCode = option.code;
                optionName = option.name();
                optionValue = option.format.convert(socketUDT.getOption(option));
                if (optionName.startsWith("UD")) continue;
                text.append("\n\t");
                text.append(optionCode);
                text.append(") ");
                text.append(optionName);
                text.append(" = ");
                text.append(optionValue);
            }
            catch (Exception e) {
                log.error("unexpected; " + optionName, (Throwable)e);
            }
        }
    }

    public int code() {
        return this.code;
    }

    public Class<?> type() {
        return this.type;
    }

    public Format format() {
        return this.format;
    }

    public String name() {
        if (this.name == null) {
            this.name = HelpUDT.constantFieldName(this.getClass(), this);
        }
        return this.name;
    }

    static {
        log = LoggerFactory.getLogger(OptionUDT.class);
        values = new CopyOnWriteArrayList();
        UDT_MSS = OptionUDT.NEW(0, Integer.class, Format.DECIMAL);
        Maximum_Transfer_Unit = OptionUDT.NEW(0, Integer.class, Format.DECIMAL);
        UDT_SNDSYN = OptionUDT.NEW(1, Boolean.class, Format.BOOLEAN);
        Is_Send_Synchronous = OptionUDT.NEW(1, Boolean.class, Format.BOOLEAN);
        UDT_RCVSYN = OptionUDT.NEW(2, Boolean.class, Format.BOOLEAN);
        Is_Receive_Synchronous = OptionUDT.NEW(2, Boolean.class, Format.BOOLEAN);
        UDT_CC = OptionUDT.NEW(3, FactoryUDT.class, Format.DEFAULT);
        Custom_Congestion_Control = OptionUDT.NEW(3, FactoryUDT.class, Format.DEFAULT);
        UDT_FC = OptionUDT.NEW(4, Integer.class, Format.BINARY);
        Flight_Window_Size = OptionUDT.NEW(4, Integer.class, Format.BINARY);
        UDT_SNDBUF = OptionUDT.NEW(5, Integer.class, Format.DECIMAL);
        Protocol_Send_Buffer_Size = OptionUDT.NEW(5, Integer.class, Format.DECIMAL);
        UDT_RCVBUF = OptionUDT.NEW(6, Integer.class, Format.DECIMAL);
        Protocol_Receive_Buffer_Size = OptionUDT.NEW(6, Integer.class, Format.DECIMAL);
        UDT_LINGER = OptionUDT.NEW(7, LingerUDT.class, Format.DECIMAL);
        Time_To_Linger_On_Close = OptionUDT.NEW(7, LingerUDT.class, Format.DECIMAL);
        UDP_SNDBUF = OptionUDT.NEW(8, Integer.class, Format.DECIMAL);
        System_Send_Buffer_Size = OptionUDT.NEW(8, Integer.class, Format.DECIMAL);
        UDP_RCVBUF = OptionUDT.NEW(9, Integer.class, Format.DECIMAL);
        System_Receive_Buffer_Size = OptionUDT.NEW(9, Integer.class, Format.DECIMAL);
        UDT_RENDEZVOUS = OptionUDT.NEW(12, Boolean.class, Format.BOOLEAN);
        Is_Randezvous_Connect_Enabled = OptionUDT.NEW(12, Boolean.class, Format.BOOLEAN);
        UDT_SNDTIMEO = OptionUDT.NEW(13, Integer.class, Format.DECIMAL);
        Send_Timeout = OptionUDT.NEW(13, Integer.class, Format.DECIMAL);
        UDT_RCVTIMEO = OptionUDT.NEW(14, Integer.class, Format.DECIMAL);
        Receive_Timeout = OptionUDT.NEW(14, Integer.class, Format.DECIMAL);
        UDT_REUSEADDR = OptionUDT.NEW(15, Boolean.class, Format.BOOLEAN);
        Is_Address_Reuse_Enabled = OptionUDT.NEW(15, Boolean.class, Format.BOOLEAN);
        UDT_MAXBW = OptionUDT.NEW(16, Long.class, Format.DECIMAL);
        Maximum_Bandwidth = OptionUDT.NEW(16, Long.class, Format.DECIMAL);
        UDT_STATE = OptionUDT.NEW(17, Integer.class, Format.DECIMAL);
        Status_Code = OptionUDT.NEW(17, Integer.class, Format.DECIMAL);
        UDT_EVENT = OptionUDT.NEW(18, Integer.class, Format.DECIMAL);
        Epoll_Event_Mask = OptionUDT.NEW(18, Integer.class, Format.DECIMAL);
        UDT_SNDDATA = OptionUDT.NEW(19, Integer.class, Format.DECIMAL);
        Send_Buffer_Consumed = OptionUDT.NEW(19, Integer.class, Format.DECIMAL);
        UDT_RCVDATA = OptionUDT.NEW(20, Integer.class, Format.DECIMAL);
        Receive_Buffer_Available = OptionUDT.NEW(20, Integer.class, Format.DECIMAL);
    }

    public static enum Format {
        DECIMAL{

            @Override
            public String convert(Object value) {
                if (value instanceof Number) {
                    long number = ((Number)value).longValue();
                    return String.format("%,d", number);
                }
                return "invalid format";
            }
        }
        ,
        BINARY{

            @Override
            public String convert(Object value) {
                if (value instanceof Number) {
                    long number = ((Number)value).longValue();
                    return String.format("%,d (%,d K)", number, number / 1024L);
                }
                return "invalid format";
            }
        }
        ,
        BOOLEAN{

            @Override
            public String convert(Object value) {
                if (value instanceof Boolean) {
                    boolean bool = (Boolean)value;
                    return String.format("%b", bool);
                }
                return "invalid format";
            }
        }
        ,
        DEFAULT{

            @Override
            public String convert(Object value) {
                return "" + value;
            }
        };


        public abstract String convert(Object var1);
    }
}

