/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable;

import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_RowContext;
import de.vandermeer.skb.interfaces.document.IsTableRow;
import de.vandermeer.skb.interfaces.document.TableRowStyle;
import de.vandermeer.skb.interfaces.document.TableRowType;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import de.vandermeer.skb.interfaces.translators.CharacterTranslator;
import de.vandermeer.skb.interfaces.translators.HtmlElementTranslator;
import de.vandermeer.skb.interfaces.translators.TargetTranslator;
import java.util.LinkedList;
import org.apache.commons.lang3.Validate;

public class AT_Row
implements IsTableRow {
    protected AT_RowContext ctx = new AT_RowContext();

    public AT_RowContext getContext() {
        return this.ctx;
    }

    public LinkedList<AT_Cell> getCells() {
        return null;
    }

    public static AT_Row createRule(final TableRowType type, final TableRowStyle style) {
        Validate.notNull((Object)type);
        Validate.validState((type != TableRowType.UNKNOWN ? 1 : 0) != 0);
        Validate.validState((type != TableRowType.CONTENT ? 1 : 0) != 0);
        Validate.notNull((Object)style);
        Validate.validState((style != TableRowStyle.UNKNOWN ? 1 : 0) != 0);
        return new AT_Row(){

            public TableRowType getType() {
                return type;
            }

            public TableRowStyle getStyle() {
                return style;
            }
        };
    }

    public static AT_Row createContentRow(Object[] content) {
        return AT_Row.createContentRow(content, TableRowStyle.NORMAL);
    }

    public static AT_Row createContentRow(Object[] content, final TableRowStyle style) {
        Validate.notNull((Object)content);
        Validate.notNull((Object)style);
        Validate.validState((style != TableRowStyle.UNKNOWN ? 1 : 0) != 0);
        final LinkedList<AT_Cell> cells = new LinkedList<AT_Cell>();
        for (Object o : content) {
            cells.add(new AT_Cell(o));
        }
        return new AT_Row(){

            public TableRowType getType() {
                return TableRowType.CONTENT;
            }

            public TableRowStyle getStyle() {
                return style;
            }

            @Override
            public LinkedList<AT_Cell> getCells() {
                return cells;
            }
        };
    }

    public AT_Row setPadding(int padding) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPadding(padding);
            }
        }
        return this;
    }

    public AT_Row setPaddingBottom(int paddingBottom) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingBottom(paddingBottom);
            }
        }
        return this;
    }

    public AT_Row setPaddingBottomChar(Character paddingBottomChar) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingBottomChar(paddingBottomChar);
            }
        }
        return this;
    }

    public AT_Row setPaddingLeft(int paddingLeft) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingLeft(paddingLeft);
            }
        }
        return this;
    }

    public AT_Row setPaddingLeftChar(Character paddingLeftChar) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingLeftChar(paddingLeftChar);
            }
        }
        return this;
    }

    public AT_Row setPaddingLeftRight(int padding) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingLeftRight(padding);
            }
        }
        return this;
    }

    public AT_Row setPaddingLeftRight(int paddingLeft, int paddingRight) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingLeftRight(paddingLeft, paddingRight);
            }
        }
        return this;
    }

    public AT_Row setPaddingRight(int paddingRight) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingRight(paddingRight);
            }
        }
        return this;
    }

    public AT_Row setPaddingRightChar(Character paddingRightChar) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingRightChar(paddingRightChar);
            }
        }
        return this;
    }

    public AT_Row setPaddingTop(int paddingTop) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingTop(paddingTop);
            }
        }
        return this;
    }

    public AT_Row setPaddingTopBottom(int padding) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingTopBottom(padding);
            }
        }
        return this;
    }

    public AT_Row setPaddingTopBottom(int paddingTop, int paddingBottom) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingTopBottom(paddingTop, paddingBottom);
            }
        }
        return this;
    }

    public AT_Row setPaddingTopChar(Character paddingTopChar) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setPaddingTopChar(paddingTopChar);
            }
        }
        return this;
    }

    public AT_Row setTextAlignment(TextAlignment textAlignment) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setTextAlignment(textAlignment);
            }
        }
        return this;
    }

    public AT_Row setTargetTranslator(TargetTranslator targetTranslator) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setTargetTranslator(targetTranslator);
            }
        }
        return this;
    }

    public AT_Row setHtmlElementTranslator(HtmlElementTranslator htmlElementTranslator) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setHtmlElementTranslator(htmlElementTranslator);
            }
        }
        return this;
    }

    public AT_Row setCharTranslator(CharacterTranslator charTranslator) {
        if (this.hasCells()) {
            for (AT_Cell cell : this.getCells()) {
                cell.getContext().setCharTranslator(charTranslator);
            }
        }
        return this;
    }
}

