/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.protocols;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolLogUtil
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String HTTP_LOG_SUPPRESSION = "http.log.exceptions.suppress.stack";
    private Configuration config;
    private Set<Class<? extends Throwable>> exceptionsLogShort = new HashSet<Class<? extends Throwable>>();

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        for (String exceptClassName : conf.getTrimmedStrings(HTTP_LOG_SUPPRESSION, new String[]{"java.net.UnknownHostException", "java.net.NoRouteToHostException"})) {
            Class clazz = conf.getClassByNameOrNull(exceptClassName);
            if (clazz == null) {
                LOG.warn("Class {} configured for log stack suppression not found.", (Object)exceptClassName);
                continue;
            }
            if (!Throwable.class.isAssignableFrom(clazz)) {
                LOG.warn("Class {} configured for log stack suppression does not extend Throwable.", (Object)exceptClassName);
                continue;
            }
            this.exceptionsLogShort.add(clazz.asSubclass(Throwable.class));
        }
    }

    public boolean logShort(Throwable t) {
        return this.exceptionsLogShort.contains(t.getClass());
    }
}

