/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.segment;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.nutch.protocol.Content;

public class ContentAsTextInputFormat
extends SequenceFileInputFormat<Text, Text> {
    public RecordReader<Text, Text> getRecordReader(InputSplit split, Job job, Mapper.Context context) throws IOException {
        context.setStatus(split.toString());
        Configuration conf = job.getConfiguration();
        return new ContentAsTextRecordReader(conf, (FileSplit)split);
    }

    private static class ContentAsTextRecordReader
    extends RecordReader<Text, Text> {
        private final SequenceFileRecordReader<Text, Content> sequenceFileRecordReader = new SequenceFileRecordReader();
        private Text innerKey = new Text();
        private Content innerValue = new Content();

        public ContentAsTextRecordReader(Configuration conf, FileSplit split) throws IOException {
        }

        public Text getCurrentValue() {
            return new Text();
        }

        public Text getCurrentKey() {
            return new Text();
        }

        public boolean nextKeyValue() {
            return false;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) {
        }

        public synchronized boolean next(Text key, Text value) throws IOException, InterruptedException {
            Text tKey = key;
            if (!this.sequenceFileRecordReader.nextKeyValue()) {
                return false;
            }
            tKey.set(this.innerKey.toString());
            String contentAsStr = new String(this.innerValue.getContent());
            contentAsStr = contentAsStr.replaceAll("\n", " ");
            value.set(contentAsStr);
            return true;
        }

        public float getProgress() throws IOException {
            return this.sequenceFileRecordReader.getProgress();
        }

        public synchronized void close() throws IOException {
            this.sequenceFileRecordReader.close();
        }
    }
}

