/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.arc;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.archive.format.arc.ARCConstants;
import org.archive.format.arc.ARCMetaData;
import org.archive.resource.AbstractResource;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.util.Base32;
import org.archive.util.StreamCopy;
import org.archive.util.io.EOFNotifyingInputStream;
import org.archive.util.io.EOFObserver;
import org.archive.util.io.PushBackOneByteInputStream;

public class ARCResource
extends AbstractResource
implements ResourceConstants,
ARCConstants,
EOFObserver {
    CountingInputStream countingIS;
    InputStream raw;
    DigestInputStream digIS;
    MetaData envelope;
    ARCMetaData arcMetaData;

    public ARCResource(MetaData metaData, ResourceContainer container, ARCMetaData arcMetaData, InputStream raw) {
        super(metaData.createChild("Payload-Metadata"), container);
        this.envelope = metaData;
        this.arcMetaData = arcMetaData;
        this.raw = raw;
        metaData.putString("Format", "ARC");
        metaData.putLong("ARC-Header-Length", arcMetaData.getHeaderLength());
        long leadingNL = arcMetaData.getLeadingNL();
        if (leadingNL > 0L) {
            metaData.putLong("Leading-Slop-Length", leadingNL);
        }
        MetaData fields = metaData.createChild("ARC-Header-Metadata");
        fields.putString("Target-URI", arcMetaData.getUrl());
        fields.putString("IP-Address", arcMetaData.getIP());
        fields.putString("Date", arcMetaData.getDateString());
        fields.putString("Content-Type", arcMetaData.getMime());
        fields.putLong("Content-Length", arcMetaData.getLength());
        this.countingIS = new CountingInputStream(ByteStreams.limit((InputStream)raw, (long)arcMetaData.getLength()));
        try {
            this.digIS = new DigestInputStream((InputStream)this.countingIS, MessageDigest.getInstance("sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public InputStream getInputStream() {
        return new EOFNotifyingInputStream(this.digIS, this);
    }

    @Override
    public void notifyEOF() throws IOException {
        PushBackOneByteInputStream pb1bis;
        long numNewlines;
        this.metaData.putLong("Actual-Content-Length", this.countingIS.getCount());
        String digString = Base32.encode(this.digIS.getMessageDigest().digest());
        this.metaData.putString("Block-Digest", "sha1:" + digString);
        if (this.container.isCompressed()) {
            this.metaData.putLong("Trailing-Slop-Length", StreamCopy.readToEOF(this.raw));
        } else if (this.raw instanceof PushBackOneByteInputStream && (numNewlines = StreamCopy.skipChars(pb1bis = (PushBackOneByteInputStream)((Object)this.raw), CR_NL_CHARS)) > 0L) {
            this.metaData.putLong("Trailing-Slop-Length", numNewlines);
        }
    }

    public MetaData getEnvelopeMetaData() {
        return this.envelope;
    }
}

