/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.target;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v120.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v120.target.model.AttachedToTarget;
import org.openqa.selenium.devtools.v120.target.model.DetachedFromTarget;
import org.openqa.selenium.devtools.v120.target.model.ReceivedMessageFromTarget;
import org.openqa.selenium.devtools.v120.target.model.RemoteLocation;
import org.openqa.selenium.devtools.v120.target.model.SessionID;
import org.openqa.selenium.devtools.v120.target.model.TargetCrashed;
import org.openqa.selenium.devtools.v120.target.model.TargetFilter;
import org.openqa.selenium.devtools.v120.target.model.TargetID;
import org.openqa.selenium.devtools.v120.target.model.TargetInfo;

public class Target {
    public static Command<Void> activateTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        return new Command("Target.activateTarget", Map.copyOf(params));
    }

    public static Command<SessionID> attachToTarget(TargetID targetId, Optional<Boolean> flatten) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        flatten.ifPresent(p -> params.put("flatten", (TargetID)p));
        return new Command("Target.attachToTarget", Map.copyOf(params), ConverterFunctions.map((String)"sessionId", SessionID.class));
    }

    @Beta
    public static Command<SessionID> attachToBrowserTarget() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Target.attachToBrowserTarget", Map.copyOf(params), ConverterFunctions.map((String)"sessionId", SessionID.class));
    }

    public static Command<Boolean> closeTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        return new Command("Target.closeTarget", Map.copyOf(params), ConverterFunctions.map((String)"success", Boolean.class));
    }

    @Beta
    public static Command<Void> exposeDevToolsProtocol(TargetID targetId, Optional<String> bindingName) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        bindingName.ifPresent(p -> params.put("bindingName", (TargetID)p));
        return new Command("Target.exposeDevToolsProtocol", Map.copyOf(params));
    }

    @Beta
    public static Command<BrowserContextID> createBrowserContext(Optional<Boolean> disposeOnDetach, Optional<String> proxyServer, Optional<String> proxyBypassList, Optional<List<String>> originsWithUniversalNetworkAccess) {
        LinkedHashMap params = new LinkedHashMap();
        disposeOnDetach.ifPresent(p -> params.put("disposeOnDetach", p));
        proxyServer.ifPresent(p -> params.put("proxyServer", p));
        proxyBypassList.ifPresent(p -> params.put("proxyBypassList", p));
        originsWithUniversalNetworkAccess.ifPresent(p -> params.put("originsWithUniversalNetworkAccess", p));
        return new Command("Target.createBrowserContext", Map.copyOf(params), ConverterFunctions.map((String)"browserContextId", BrowserContextID.class));
    }

    @Beta
    public static Command<List<BrowserContextID>> getBrowserContexts() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Target.getBrowserContexts", Map.copyOf(params), ConverterFunctions.map((String)"browserContextIds", input -> input.readArray(BrowserContextID.class)));
    }

    public static Command<TargetID> createTarget(String url, Optional<Integer> width, Optional<Integer> height, Optional<BrowserContextID> browserContextId, Optional<Boolean> enableBeginFrameControl, Optional<Boolean> newWindow, Optional<Boolean> background, Optional<Boolean> forTab) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        width.ifPresent(p -> params.put("width", (String)p));
        height.ifPresent(p -> params.put("height", (String)p));
        browserContextId.ifPresent(p -> params.put("browserContextId", (String)p));
        enableBeginFrameControl.ifPresent(p -> params.put("enableBeginFrameControl", (String)p));
        newWindow.ifPresent(p -> params.put("newWindow", (String)p));
        background.ifPresent(p -> params.put("background", (String)p));
        forTab.ifPresent(p -> params.put("forTab", (String)p));
        return new Command("Target.createTarget", Map.copyOf(params), ConverterFunctions.map((String)"targetId", TargetID.class));
    }

    public static Command<Void> detachFromTarget(Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        LinkedHashMap params = new LinkedHashMap();
        sessionId.ifPresent(p -> params.put("sessionId", p));
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command("Target.detachFromTarget", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> disposeBrowserContext(BrowserContextID browserContextId) {
        Objects.requireNonNull(browserContextId, "browserContextId is required");
        LinkedHashMap<String, BrowserContextID> params = new LinkedHashMap<String, BrowserContextID>();
        params.put("browserContextId", browserContextId);
        return new Command("Target.disposeBrowserContext", Map.copyOf(params));
    }

    @Beta
    public static Command<TargetInfo> getTargetInfo(Optional<TargetID> targetId) {
        LinkedHashMap params = new LinkedHashMap();
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command("Target.getTargetInfo", Map.copyOf(params), ConverterFunctions.map((String)"targetInfo", TargetInfo.class));
    }

    public static Command<List<TargetInfo>> getTargets(Optional<TargetFilter> filter) {
        LinkedHashMap params = new LinkedHashMap();
        filter.ifPresent(p -> params.put("filter", p));
        return new Command("Target.getTargets", Map.copyOf(params), ConverterFunctions.map((String)"targetInfos", input -> input.readArray(TargetInfo.class)));
    }

    @Deprecated
    public static Command<Void> sendMessageToTarget(String message, Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        Objects.requireNonNull(message, "message is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("message", message);
        sessionId.ifPresent(p -> params.put("sessionId", (String)p));
        targetId.ifPresent(p -> params.put("targetId", (String)p));
        return new Command("Target.sendMessageToTarget", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart, Optional<Boolean> flatten, Optional<TargetFilter> filter) {
        Objects.requireNonNull(autoAttach, "autoAttach is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("autoAttach", autoAttach);
        params.put("waitForDebuggerOnStart", waitForDebuggerOnStart);
        flatten.ifPresent(p -> params.put("flatten", (Boolean)p));
        filter.ifPresent(p -> params.put("filter", (Boolean)p));
        return new Command("Target.setAutoAttach", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> autoAttachRelated(TargetID targetId, Boolean waitForDebuggerOnStart, Optional<TargetFilter> filter) {
        Objects.requireNonNull(targetId, "targetId is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("targetId", targetId);
        params.put("waitForDebuggerOnStart", waitForDebuggerOnStart);
        filter.ifPresent(p -> params.put("filter", p));
        return new Command("Target.autoAttachRelated", Map.copyOf(params));
    }

    public static Command<Void> setDiscoverTargets(Boolean discover, Optional<TargetFilter> filter) {
        Objects.requireNonNull(discover, "discover is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("discover", discover);
        filter.ifPresent(p -> params.put("filter", (Boolean)p));
        return new Command("Target.setDiscoverTargets", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setRemoteLocations(List<RemoteLocation> locations) {
        Objects.requireNonNull(locations, "locations is required");
        LinkedHashMap<String, List<RemoteLocation>> params = new LinkedHashMap<String, List<RemoteLocation>>();
        params.put("locations", locations);
        return new Command("Target.setRemoteLocations", Map.copyOf(params));
    }

    public static Event<AttachedToTarget> attachedToTarget() {
        return new Event("Target.attachedToTarget", input -> (AttachedToTarget)input.read(AttachedToTarget.class));
    }

    public static Event<DetachedFromTarget> detachedFromTarget() {
        return new Event("Target.detachedFromTarget", input -> (DetachedFromTarget)input.read(DetachedFromTarget.class));
    }

    public static Event<ReceivedMessageFromTarget> receivedMessageFromTarget() {
        return new Event("Target.receivedMessageFromTarget", input -> (ReceivedMessageFromTarget)input.read(ReceivedMessageFromTarget.class));
    }

    public static Event<TargetInfo> targetCreated() {
        return new Event("Target.targetCreated", ConverterFunctions.map((String)"targetInfo", TargetInfo.class));
    }

    public static Event<TargetID> targetDestroyed() {
        return new Event("Target.targetDestroyed", ConverterFunctions.map((String)"targetId", TargetID.class));
    }

    public static Event<TargetCrashed> targetCrashed() {
        return new Event("Target.targetCrashed", input -> (TargetCrashed)input.read(TargetCrashed.class));
    }

    public static Event<TargetInfo> targetInfoChanged() {
        return new Event("Target.targetInfoChanged", ConverterFunctions.map((String)"targetInfo", TargetInfo.class));
    }
}

