/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.james.mime4j.util.BufferRecycler;
import shaded.org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class ByteArrayOutputStreamRecycler {
    protected final ConcurrentLinkedQueue<UnsynchronizedByteArrayOutputStream> buffers = new ConcurrentLinkedQueue();

    public Wrapper allocOutputStream() {
        UnsynchronizedByteArrayOutputStream result = this.buffers.poll();
        if (result == null) {
            result = new UnsynchronizedByteArrayOutputStream();
        }
        return new Wrapper(this, result);
    }

    private void release(UnsynchronizedByteArrayOutputStream value) {
        if (value != null && BufferRecycler.ENABLED) {
            value.reset();
            this.buffers.offer(value);
        }
    }

    public static class Wrapper {
        private final ByteArrayOutputStreamRecycler recycler;
        private final UnsynchronizedByteArrayOutputStream value;

        public Wrapper(ByteArrayOutputStreamRecycler recycler, UnsynchronizedByteArrayOutputStream value) {
            this.recycler = recycler;
            this.value = value;
        }

        public void release() {
            this.recycler.release(this.value);
        }

        public UnsynchronizedByteArrayOutputStream getValue() {
            return this.value;
        }
    }
}

