/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.debug.ODataDebugResponseWrapper;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class DebugInfoServer
implements DebugInfo {
    private final Map<String, String> environment = new TreeMap<String, String>();

    public DebugInfoServer(HttpServletRequest httpServletRequest) {
        this.environment.put("authType", httpServletRequest.getAuthType());
        this.environment.put("localAddr", httpServletRequest.getLocalAddr());
        this.environment.put("localName", httpServletRequest.getLocalName());
        this.addInt("localPort", httpServletRequest.getLocalPort());
        this.environment.put("pathInfo", httpServletRequest.getPathInfo());
        this.environment.put("pathTranslated", httpServletRequest.getPathTranslated());
        this.environment.put("remoteAddr", httpServletRequest.getRemoteAddr());
        this.environment.put("remoteHost", httpServletRequest.getRemoteHost());
        this.addInt("remotePort", httpServletRequest.getRemotePort());
        this.environment.put("remoteUser", httpServletRequest.getRemoteUser());
        this.environment.put("scheme", httpServletRequest.getScheme());
        this.environment.put("serverName", httpServletRequest.getServerName());
        this.addInt("serverPort", httpServletRequest.getServerPort());
        this.environment.put("servletPath", httpServletRequest.getServletPath());
    }

    @Override
    public String getName() {
        return "Environment";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        ODataDebugResponseWrapper.appendJsonTable(jsonStreamWriter, this.environment);
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        Package pack = ODataDebugResponseWrapper.class.getPackage();
        writer.append("<h2>Library Version</h2>\n").append("<p>").append(pack.getImplementationTitle()).append(" Version ").append(pack.getImplementationVersion()).append("</p>\n").append("<h2>Server Environment</h2>\n");
        ODataDebugResponseWrapper.appendHtmlTable(writer, this.environment);
    }

    private void addInt(String name, int number) {
        this.environment.put(name, number == 0 ? null : Integer.toString(number));
    }
}

