/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonErrorDocumentProducer {
    public void writeErrorDocument(Writer writer, String errorCode, String message, Locale locale, String innerError) throws IOException {
        ODataErrorContext context = new ODataErrorContext();
        context.setErrorCode(errorCode);
        context.setMessage(message);
        context.setLocale(locale);
        context.setInnerError(innerError);
        this.writeErrorDocument(writer, context);
    }

    public void writeErrorDocument(Writer writer, ODataErrorContext context) throws IOException {
        Locale locale = context.getLocale();
        String innerError = context.getInnerError();
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        jsonStreamWriter.beginObject().name("error").beginObject().namedStringValue("code", context.getErrorCode()).separator().name("message").beginObject().namedStringValueRaw("lang", locale == null || locale.getLanguage() == null ? null : locale.getLanguage() + (locale.getCountry() == null || locale.getCountry().isEmpty() ? "" : "-" + locale.getCountry())).separator().namedStringValue("value", context.getMessage()).endObject();
        if (!context.getErrorDetails().isEmpty()) {
            int cntr = 0;
            jsonStreamWriter.separator().name("innererror").beginObject().name("errordetails").beginArray();
            for (ODataErrorContext detail : context.getErrorDetails()) {
                if (cntr > 0) {
                    jsonStreamWriter.separator();
                }
                ++cntr;
                jsonStreamWriter.beginObject().namedStringValue("code", detail.getErrorCode()).separator().namedStringValue("message", detail.getMessage()).separator().namedStringValue("target", detail.getTarget()).separator().namedStringValue("severity", detail.getSeverity()).endObject();
            }
            jsonStreamWriter.endArray().endObject();
        } else if (innerError != null) {
            jsonStreamWriter.separator().namedStringValue("innererror", innerError);
        }
        jsonStreamWriter.endObject().endObject();
    }
}

