/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class Target {
    private String targetName;
    private FullQualifiedName entityContainer;

    public Target(String target, EdmEntityContainer defaultContainer) {
        String[] bindingTargetParts = target.split("/");
        if (bindingTargetParts.length == 1) {
            this.entityContainer = defaultContainer.getFullQualifiedName();
            this.targetName = bindingTargetParts[0];
        } else {
            this.entityContainer = new FullQualifiedName(bindingTargetParts[0]);
            this.targetName = bindingTargetParts[1];
        }
    }

    public String getTargetName() {
        return this.targetName;
    }

    public FullQualifiedName getEntityContainer() {
        return this.entityContainer;
    }

    public String toString() {
        if (this.entityContainer == null) {
            return this.targetName;
        }
        return this.entityContainer.getFullQualifiedNameAsString() + "/" + this.targetName;
    }
}

