/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigInteger;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmByte
extends SingletonPrimitiveType {
    private static final EdmByte INSTANCE = new EdmByte();

    public static EdmByte getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Short.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Short valueShort;
        try {
            valueShort = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", (Exception)e);
        }
        if (valueShort < 0 || valueShort >= 256) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        try {
            return EdmInt64.convertNumber(valueShort, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            if (((Number)value).longValue() >= 0L && ((Number)value).longValue() < 256L) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && ((BigInteger)value).compareTo(BigInteger.valueOf(256L)) < 0) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

