/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.tree;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.db.dao.file.FileItemLogDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItemLog;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ConvertingErrorsDialog
extends Modal<BaseFileItem> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer container = new WebMarkupContainer("container");
    private final Label message = new Label("message", (IModel)Model.of((Serializable)((Object)((String)null))));
    private final ListView<FileItemLog> logView = new ListView<FileItemLog>("row"){
        private static final long serialVersionUID = 1L;

        protected void populateItem(ListItem<FileItemLog> item) {
            FileItemLog l = (FileItemLog)item.getModelObject();
            item.add(new Component[]{new Label("exitCode", (Serializable)l.getExitCode())});
            item.add(new Component[]{new Label("message", (Serializable)((Object)l.getMessage()))});
            if (!l.isOk()) {
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"alert"))});
            }
            if (l.isWarn()) {
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"warn"))});
            }
        }
    };
    private Component headerLabel;
    @Inject
    private FileItemLogDao fileLogDao;

    public ConvertingErrorsDialog(String id, IModel<BaseFileItem> model) {
        super(id, model);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("887"));
        this.size(Modal.Size.Large);
        super.onInitialize();
        this.add(new Component[]{this.container.add(new Component[]{this.message.setVisible(false), this.logView.setVisible(false)}).setOutputMarkupId(true)});
    }

    protected Component createHeaderLabel(String id, String label) {
        this.headerLabel = super.createHeaderLabel(id, label);
        return this.headerLabel;
    }

    public Modal<BaseFileItem> show(IPartialPageRequestHandler handler) {
        BaseFileItem f = (BaseFileItem)this.getModelObject();
        this.headerLabel.setDefaultModel((IModel)new ResourceModel(f.getType() == BaseFileItem.Type.RECORDING ? "887" : "convert.errors.file"));
        List logs = this.fileLogDao.get(f);
        if (f.getHash() == null) {
            this.message.setVisible(true);
            this.message.setDefaultModelObject((Object)this.getString("888"));
        } else if (!f.exists()) {
            this.message.setVisible(true);
            this.message.setDefaultModelObject((Object)this.getString(f.getType() == BaseFileItem.Type.RECORDING ? "1595" : "convert.errors.file.missing"));
        } else {
            this.message.setVisible(false);
        }
        if (!logs.isEmpty()) {
            this.logView.setVisible(false);
            this.logView.setList(logs).setVisible(true);
        }
        handler.add(new Component[]{this.container, this.headerLabel});
        return super.show(handler);
    }
}

