/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages;

import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.pages.BaseInitedPage;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.request.IRequestParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthorizeInstantiation(value={"ADMIN", "DASHBOARD", "ROOM"})
public class MainPage
extends BaseInitedPage {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MainPage.class);
    private static final String MAIN_PANEL_ID = "main";
    private final WebMarkupContainer mainContainer = new WebMarkupContainer("main-container");
    private MainPanel main;
    private OmUrlFragment uf = null;
    private boolean inited = false;
    private boolean loaded = false;

    public void updateContents(OmUrlFragment f, IPartialPageRequestHandler handler) {
        this.main.updateContents(f, handler);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.getHeader().setVisible(false);
        EmptyPanel temp = new EmptyPanel(MAIN_PANEL_ID);
        this.add(new Behavior[]{this.newDelayedLoad()});
        this.add(new Component[]{this.mainContainer.add(new Component[]{temp}).setOutputMarkupId(true)});
    }

    private AbstractDefaultAjaxBehavior newDelayedLoad() {
        return new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                log.debug("MainPage::delayedLoad");
                MainPage.this.main = new MainPanel(MainPage.MAIN_PANEL_ID);
                target.add(new Component[]{MainPage.this.mainContainer.replace((Component)MainPage.this.main).add(new Behavior[]{MainPage.this.newAreaBehavior()})});
            }

            public void renderHead(Component component, IHeaderResponse response) {
                if (!MainPage.this.inited) {
                    log.debug("renderHead:: newDelayedLoad");
                    MainPage.this.inited = true;
                    super.renderHead(component, response);
                    response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getCallbackScript()));
                }
            }
        };
    }

    private AbstractDefaultAjaxBehavior newAreaBehavior() {
        return new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                MainPage.this.loaded = true;
                log.debug("MainPage::areaBehavior");
                if (MainPage.this.uf == null) {
                    MainPage.this.uf = WebSession.get().getArea();
                }
                MainPage.this.main.updateContents(MainPage.this.uf == null ? OmUrlFragment.get() : MainPage.this.uf, (IPartialPageRequestHandler)target);
                WebSession.get().setArea(null);
            }

            public void renderHead(Component component, IHeaderResponse response) {
                if (!MainPage.this.loaded) {
                    log.debug("renderHead:: newAreaBehavior");
                    super.renderHead(component, response);
                    MainPage.this.internalRenderHead(response);
                    response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getCallbackScript()));
                }
            }
        };
    }

    @Override
    protected boolean isMainPage() {
        return true;
    }

    protected void onParameterArrival(IRequestParameters params, AjaxRequestTarget target) {
        log.debug("MainPage::onParameterArrival");
        OmUrlFragment newf = this.getUrlFragment(params);
        if (newf != null) {
            this.uf = newf;
        }
        if (this.loaded && newf != null) {
            this.main.updateContents(newf, (IPartialPageRequestHandler)target, false);
        }
    }
}

