/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class ScheduledExecutorSubmitToPartitionCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1704448;
    public static final int RESPONSE_MESSAGE_TYPE = 1704449;
    private static final int REQUEST_TYPE_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_DELAY_IN_MILLIS_FIELD_OFFSET = 17;
    private static final int REQUEST_PERIOD_IN_MILLIS_FIELD_OFFSET = 25;
    private static final int REQUEST_AUTO_DISPOSABLE_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 34;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private ScheduledExecutorSubmitToPartitionCodec() {
    }

    public static ClientMessage encodeRequest(String schedulerName, byte type, String taskName, Data task, long initialDelayInMillis, long periodInMillis, boolean autoDisposable) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("ScheduledExecutor.SubmitToPartition");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[34], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1704448);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 16, type);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 17, initialDelayInMillis);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 25, periodInMillis);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 33, autoDisposable);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, schedulerName);
        StringCodec.encode(clientMessage, taskName);
        DataCodec.encode(clientMessage, task);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.type = FixedSizeTypesCodec.decodeByte(initialFrame.content, 16);
        request.initialDelayInMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 17);
        request.periodInMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 25);
        if (initialFrame.content.length >= 34) {
            request.autoDisposable = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 33);
            request.isAutoDisposableExists = true;
        } else {
            request.isAutoDisposableExists = false;
        }
        request.schedulerName = StringCodec.decode(iterator);
        request.taskName = StringCodec.decode(iterator);
        request.task = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1704449);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String schedulerName;
        public byte type;
        public String taskName;
        public Data task;
        public long initialDelayInMillis;
        public long periodInMillis;
        public boolean autoDisposable;
        public boolean isAutoDisposableExists;
    }
}

