/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.partition.LocalReplicationStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalReplicationStatsImpl
implements LocalReplicationStats {
    private static final AtomicLongFieldUpdater<LocalReplicationStatsImpl> FULL_PARTITION_REPLICATION_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicationStatsImpl.class, "fullPartitionReplicationCount");
    private static final AtomicLongFieldUpdater<LocalReplicationStatsImpl> DIFF_PARTITION_REPLICATION_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicationStatsImpl.class, "diffPartitionReplicationCount");
    private static final AtomicLongFieldUpdater<LocalReplicationStatsImpl> FULL_PARTITION_REPLICATION_RECORDS_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicationStatsImpl.class, "fullPartitionReplicationRecordsCount");
    private static final AtomicLongFieldUpdater<LocalReplicationStatsImpl> DIFF_PARTITION_REPLICATION_RECORDS_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicationStatsImpl.class, "diffPartitionReplicationRecordsCount");
    @Probe(name="fullPartitionReplicationCount")
    private volatile long fullPartitionReplicationCount;
    @Probe(name="differentialPartitionReplicationCount")
    private volatile long diffPartitionReplicationCount;
    @Probe(name="fullPartitionReplicationRecordsCount")
    private volatile long fullPartitionReplicationRecordsCount;
    @Probe(name="differentialPartitionReplicationRecordsCount")
    private volatile long diffPartitionReplicationRecordsCount;

    @Override
    public long getDifferentialReplicationRecordCount() {
        return this.diffPartitionReplicationRecordsCount;
    }

    @Override
    public long getFullReplicationRecordCount() {
        return this.fullPartitionReplicationRecordsCount;
    }

    @Override
    public long getDifferentialPartitionReplicationCount() {
        return this.diffPartitionReplicationCount;
    }

    @Override
    public long getFullPartitionReplicationCount() {
        return this.fullPartitionReplicationCount;
    }

    public void incrementFullPartitionReplicationCount() {
        FULL_PARTITION_REPLICATION_COUNT.incrementAndGet(this);
    }

    public void incrementDiffPartitionReplicationCount() {
        DIFF_PARTITION_REPLICATION_COUNT.incrementAndGet(this);
    }

    public void incrementFullPartitionReplicationRecordsCount(long delta) {
        FULL_PARTITION_REPLICATION_RECORDS_COUNT.addAndGet(this, delta);
    }

    public void incrementDiffPartitionReplicationRecordsCount(long delta) {
        DIFF_PARTITION_REPLICATION_RECORDS_COUNT.addAndGet(this, delta);
    }

    public String toString() {
        return "LocalReplicationStats{fullPartitionReplicationCount=" + this.fullPartitionReplicationCount + ", differentialPartitionReplicationCount=" + this.diffPartitionReplicationCount + ", fullPartitionReplicationRecordsCount=" + this.fullPartitionReplicationRecordsCount + ", differentialPartitionReplicationRecordsCount=" + this.diffPartitionReplicationRecordsCount + "}";
    }
}

