/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged is the corresponding interface of BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
type BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter
	// IsBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged()
	// CreateBuilder creates a BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
}

// _BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged is the data-structure of this message
type _BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged struct {
	Header BACnetTagHeader
	Value  BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged = (*_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged)(nil)

// NewBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged factory function for _BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
func NewBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged(header BACnetTagHeader, value BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter, tagNumber uint8, tagClass TagClass) *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged must not be nil")
	}
	return &_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder is a builder for BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
type BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
	// Build builds the BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged or returns an error if something is wrong
	Build() (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
}

// NewBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder() creates a BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
func NewBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	return &_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder{_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged: new(_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged)}
}

type _BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder struct {
	*_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged

	collectedErr []error
}

var _ (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) = (*_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder)(nil)

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) WithValue(value BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) Build() (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged.deepCopy(), nil
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) MustBuild() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder().(*_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder creates a BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder
func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder {
	if b == nil {
		return NewBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder()
	}
	return &_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder{_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetValue() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged(structType any) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged {
	if casted, ok := structType.(BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetTypeName() string {
	return "BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged"
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, error) {
	return BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, error) {
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, error) {
	v, err := (&_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter](ctx, "value", readBuffer, EnsureType[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter_OFFNORMAL)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged")
	}

	return m, nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) IsBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged() {
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) deepCopy() *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged {
	if m == nil {
		return nil
	}
	_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedCopy := &_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedCopy
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
