/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MonitoredItemModifyResult is the corresponding interface of MonitoredItemModifyResult
type MonitoredItemModifyResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetRevisedSamplingInterval returns RevisedSamplingInterval (property field)
	GetRevisedSamplingInterval() float64
	// GetRevisedQueueSize returns RevisedQueueSize (property field)
	GetRevisedQueueSize() uint32
	// GetFilterResult returns FilterResult (property field)
	GetFilterResult() ExtensionObject
	// IsMonitoredItemModifyResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMonitoredItemModifyResult()
	// CreateBuilder creates a MonitoredItemModifyResultBuilder
	CreateMonitoredItemModifyResultBuilder() MonitoredItemModifyResultBuilder
}

// _MonitoredItemModifyResult is the data-structure of this message
type _MonitoredItemModifyResult struct {
	ExtensionObjectDefinitionContract
	StatusCode              StatusCode
	RevisedSamplingInterval float64
	RevisedQueueSize        uint32
	FilterResult            ExtensionObject
}

var _ MonitoredItemModifyResult = (*_MonitoredItemModifyResult)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_MonitoredItemModifyResult)(nil)

// NewMonitoredItemModifyResult factory function for _MonitoredItemModifyResult
func NewMonitoredItemModifyResult(statusCode StatusCode, revisedSamplingInterval float64, revisedQueueSize uint32, filterResult ExtensionObject) *_MonitoredItemModifyResult {
	if statusCode == nil {
		panic("statusCode of type StatusCode for MonitoredItemModifyResult must not be nil")
	}
	if filterResult == nil {
		panic("filterResult of type ExtensionObject for MonitoredItemModifyResult must not be nil")
	}
	_result := &_MonitoredItemModifyResult{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		StatusCode:                        statusCode,
		RevisedSamplingInterval:           revisedSamplingInterval,
		RevisedQueueSize:                  revisedQueueSize,
		FilterResult:                      filterResult,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MonitoredItemModifyResultBuilder is a builder for MonitoredItemModifyResult
type MonitoredItemModifyResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(statusCode StatusCode, revisedSamplingInterval float64, revisedQueueSize uint32, filterResult ExtensionObject) MonitoredItemModifyResultBuilder
	// WithStatusCode adds StatusCode (property field)
	WithStatusCode(StatusCode) MonitoredItemModifyResultBuilder
	// WithStatusCodeBuilder adds StatusCode (property field) which is build by the builder
	WithStatusCodeBuilder(func(StatusCodeBuilder) StatusCodeBuilder) MonitoredItemModifyResultBuilder
	// WithRevisedSamplingInterval adds RevisedSamplingInterval (property field)
	WithRevisedSamplingInterval(float64) MonitoredItemModifyResultBuilder
	// WithRevisedQueueSize adds RevisedQueueSize (property field)
	WithRevisedQueueSize(uint32) MonitoredItemModifyResultBuilder
	// WithFilterResult adds FilterResult (property field)
	WithFilterResult(ExtensionObject) MonitoredItemModifyResultBuilder
	// WithFilterResultBuilder adds FilterResult (property field) which is build by the builder
	WithFilterResultBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) MonitoredItemModifyResultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the MonitoredItemModifyResult or returns an error if something is wrong
	Build() (MonitoredItemModifyResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MonitoredItemModifyResult
}

// NewMonitoredItemModifyResultBuilder() creates a MonitoredItemModifyResultBuilder
func NewMonitoredItemModifyResultBuilder() MonitoredItemModifyResultBuilder {
	return &_MonitoredItemModifyResultBuilder{_MonitoredItemModifyResult: new(_MonitoredItemModifyResult)}
}

type _MonitoredItemModifyResultBuilder struct {
	*_MonitoredItemModifyResult

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (MonitoredItemModifyResultBuilder) = (*_MonitoredItemModifyResultBuilder)(nil)

func (b *_MonitoredItemModifyResultBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._MonitoredItemModifyResult
}

func (b *_MonitoredItemModifyResultBuilder) WithMandatoryFields(statusCode StatusCode, revisedSamplingInterval float64, revisedQueueSize uint32, filterResult ExtensionObject) MonitoredItemModifyResultBuilder {
	return b.WithStatusCode(statusCode).WithRevisedSamplingInterval(revisedSamplingInterval).WithRevisedQueueSize(revisedQueueSize).WithFilterResult(filterResult)
}

func (b *_MonitoredItemModifyResultBuilder) WithStatusCode(statusCode StatusCode) MonitoredItemModifyResultBuilder {
	b.StatusCode = statusCode
	return b
}

func (b *_MonitoredItemModifyResultBuilder) WithStatusCodeBuilder(builderSupplier func(StatusCodeBuilder) StatusCodeBuilder) MonitoredItemModifyResultBuilder {
	builder := builderSupplier(b.StatusCode.CreateStatusCodeBuilder())
	var err error
	b.StatusCode, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StatusCodeBuilder failed"))
	}
	return b
}

func (b *_MonitoredItemModifyResultBuilder) WithRevisedSamplingInterval(revisedSamplingInterval float64) MonitoredItemModifyResultBuilder {
	b.RevisedSamplingInterval = revisedSamplingInterval
	return b
}

func (b *_MonitoredItemModifyResultBuilder) WithRevisedQueueSize(revisedQueueSize uint32) MonitoredItemModifyResultBuilder {
	b.RevisedQueueSize = revisedQueueSize
	return b
}

func (b *_MonitoredItemModifyResultBuilder) WithFilterResult(filterResult ExtensionObject) MonitoredItemModifyResultBuilder {
	b.FilterResult = filterResult
	return b
}

func (b *_MonitoredItemModifyResultBuilder) WithFilterResultBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) MonitoredItemModifyResultBuilder {
	builder := builderSupplier(b.FilterResult.CreateExtensionObjectBuilder())
	var err error
	b.FilterResult, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_MonitoredItemModifyResultBuilder) Build() (MonitoredItemModifyResult, error) {
	if b.StatusCode == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'statusCode' not set"))
	}
	if b.FilterResult == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'filterResult' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MonitoredItemModifyResult.deepCopy(), nil
}

func (b *_MonitoredItemModifyResultBuilder) MustBuild() MonitoredItemModifyResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MonitoredItemModifyResultBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_MonitoredItemModifyResultBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_MonitoredItemModifyResultBuilder) DeepCopy() any {
	_copy := b.CreateMonitoredItemModifyResultBuilder().(*_MonitoredItemModifyResultBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMonitoredItemModifyResultBuilder creates a MonitoredItemModifyResultBuilder
func (b *_MonitoredItemModifyResult) CreateMonitoredItemModifyResultBuilder() MonitoredItemModifyResultBuilder {
	if b == nil {
		return NewMonitoredItemModifyResultBuilder()
	}
	return &_MonitoredItemModifyResultBuilder{_MonitoredItemModifyResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_MonitoredItemModifyResult) GetExtensionId() int32 {
	return int32(760)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MonitoredItemModifyResult) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MonitoredItemModifyResult) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_MonitoredItemModifyResult) GetRevisedSamplingInterval() float64 {
	return m.RevisedSamplingInterval
}

func (m *_MonitoredItemModifyResult) GetRevisedQueueSize() uint32 {
	return m.RevisedQueueSize
}

func (m *_MonitoredItemModifyResult) GetFilterResult() ExtensionObject {
	return m.FilterResult
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMonitoredItemModifyResult(structType any) MonitoredItemModifyResult {
	if casted, ok := structType.(MonitoredItemModifyResult); ok {
		return casted
	}
	if casted, ok := structType.(*MonitoredItemModifyResult); ok {
		return *casted
	}
	return nil
}

func (m *_MonitoredItemModifyResult) GetTypeName() string {
	return "MonitoredItemModifyResult"
}

func (m *_MonitoredItemModifyResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (statusCode)
	lengthInBits += m.StatusCode.GetLengthInBits(ctx)

	// Simple field (revisedSamplingInterval)
	lengthInBits += 64

	// Simple field (revisedQueueSize)
	lengthInBits += 32

	// Simple field (filterResult)
	lengthInBits += m.FilterResult.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_MonitoredItemModifyResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MonitoredItemModifyResult) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__monitoredItemModifyResult MonitoredItemModifyResult, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MonitoredItemModifyResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MonitoredItemModifyResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	statusCode, err := ReadSimpleField[StatusCode](ctx, "statusCode", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusCode' field"))
	}
	m.StatusCode = statusCode

	revisedSamplingInterval, err := ReadSimpleField(ctx, "revisedSamplingInterval", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'revisedSamplingInterval' field"))
	}
	m.RevisedSamplingInterval = revisedSamplingInterval

	revisedQueueSize, err := ReadSimpleField(ctx, "revisedQueueSize", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'revisedQueueSize' field"))
	}
	m.RevisedQueueSize = revisedQueueSize

	filterResult, err := ReadSimpleField[ExtensionObject](ctx, "filterResult", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'filterResult' field"))
	}
	m.FilterResult = filterResult

	if closeErr := readBuffer.CloseContext("MonitoredItemModifyResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MonitoredItemModifyResult")
	}

	return m, nil
}

func (m *_MonitoredItemModifyResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MonitoredItemModifyResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MonitoredItemModifyResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MonitoredItemModifyResult")
		}

		if err := WriteSimpleField[StatusCode](ctx, "statusCode", m.GetStatusCode(), WriteComplex[StatusCode](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'statusCode' field")
		}

		if err := WriteSimpleField[float64](ctx, "revisedSamplingInterval", m.GetRevisedSamplingInterval(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'revisedSamplingInterval' field")
		}

		if err := WriteSimpleField[uint32](ctx, "revisedQueueSize", m.GetRevisedQueueSize(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'revisedQueueSize' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "filterResult", m.GetFilterResult(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'filterResult' field")
		}

		if popErr := writeBuffer.PopContext("MonitoredItemModifyResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MonitoredItemModifyResult")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MonitoredItemModifyResult) IsMonitoredItemModifyResult() {}

func (m *_MonitoredItemModifyResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MonitoredItemModifyResult) deepCopy() *_MonitoredItemModifyResult {
	if m == nil {
		return nil
	}
	_MonitoredItemModifyResultCopy := &_MonitoredItemModifyResult{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[StatusCode](m.StatusCode),
		m.RevisedSamplingInterval,
		m.RevisedQueueSize,
		utils.DeepCopy[ExtensionObject](m.FilterResult),
	}
	_MonitoredItemModifyResultCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _MonitoredItemModifyResultCopy
}

func (m *_MonitoredItemModifyResult) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
