/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableMonitoring is an enum
type OpcuaNodeIdServicesVariableMonitoring int32

type IOpcuaNodeIdServicesVariableMonitoring interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableMonitoring_MonitoringMode_EnumStrings OpcuaNodeIdServicesVariableMonitoring = 7608
)

var OpcuaNodeIdServicesVariableMonitoringValues []OpcuaNodeIdServicesVariableMonitoring

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableMonitoringValues = []OpcuaNodeIdServicesVariableMonitoring{
		OpcuaNodeIdServicesVariableMonitoring_MonitoringMode_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableMonitoringByValue(value int32) (enum OpcuaNodeIdServicesVariableMonitoring, ok bool) {
	switch value {
	case 7608:
		return OpcuaNodeIdServicesVariableMonitoring_MonitoringMode_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableMonitoringByName(value string) (enum OpcuaNodeIdServicesVariableMonitoring, ok bool) {
	switch value {
	case "MonitoringMode_EnumStrings":
		return OpcuaNodeIdServicesVariableMonitoring_MonitoringMode_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableMonitoringKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableMonitoringValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableMonitoring(structType any) OpcuaNodeIdServicesVariableMonitoring {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableMonitoring {
		if sOpcuaNodeIdServicesVariableMonitoring, ok := typ.(OpcuaNodeIdServicesVariableMonitoring); ok {
			return sOpcuaNodeIdServicesVariableMonitoring
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableMonitoring) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableMonitoring) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableMonitoringParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableMonitoring, error) {
	return OpcuaNodeIdServicesVariableMonitoringParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableMonitoringParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableMonitoring, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableMonitoring", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableMonitoring")
	}
	if enum, ok := OpcuaNodeIdServicesVariableMonitoringByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableMonitoring")
		return OpcuaNodeIdServicesVariableMonitoring(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableMonitoring) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableMonitoring) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableMonitoring", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableMonitoring) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableMonitoring) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableMonitoring_MonitoringMode_EnumStrings:
		return "MonitoringMode_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableMonitoring) String() string {
	return e.PLC4XEnumName()
}
