/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * Reflection
 */
@JsonPropertyOrder({
  Reflection.JSON_PROPERTY_OBJECTS,
  Reflection.JSON_PROPERTY_ENUMS,
  Reflection.JSON_PROPERTY_FILE_IDENT,
  Reflection.JSON_PROPERTY_FILE_EXT,
  Reflection.JSON_PROPERTY_ROOT_TABLE,
  Reflection.JSON_PROPERTY_SERVICES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class Reflection {
  public static final String JSON_PROPERTY_OBJECTS = "objects";
  private List<ReflectionObject> objects = new ArrayList<>();

  public static final String JSON_PROPERTY_ENUMS = "enums";
  private List<ReflectionEnum> enums = new ArrayList<>();

  public static final String JSON_PROPERTY_FILE_IDENT = "file_ident";
  private String fileIdent;

  public static final String JSON_PROPERTY_FILE_EXT = "file_ext";
  private String fileExt;

  public static final String JSON_PROPERTY_ROOT_TABLE = "root_table";
  private ReflectionObject rootTable;

  public static final String JSON_PROPERTY_SERVICES = "services";
  private List<ReflectionService> services = new ArrayList<>();

  public Reflection() {
  }

  public Reflection objects(List<ReflectionObject> objects) {
    
    this.objects = objects;
    return this;
  }

  public Reflection addObjectsItem(ReflectionObject objectsItem) {
    this.objects.add(objectsItem);
    return this;
  }

   /**
   * Get objects
   * @return objects
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OBJECTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<ReflectionObject> getObjects() {
    return objects;
  }


  @JsonProperty(JSON_PROPERTY_OBJECTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setObjects(List<ReflectionObject> objects) {
    this.objects = objects;
  }


  public Reflection enums(List<ReflectionEnum> enums) {
    
    this.enums = enums;
    return this;
  }

  public Reflection addEnumsItem(ReflectionEnum enumsItem) {
    this.enums.add(enumsItem);
    return this;
  }

   /**
   * Get enums
   * @return enums
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ENUMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<ReflectionEnum> getEnums() {
    return enums;
  }


  @JsonProperty(JSON_PROPERTY_ENUMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnums(List<ReflectionEnum> enums) {
    this.enums = enums;
  }


  public Reflection fileIdent(String fileIdent) {
    
    this.fileIdent = fileIdent;
    return this;
  }

   /**
   * Get fileIdent
   * @return fileIdent
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_IDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileIdent() {
    return fileIdent;
  }


  @JsonProperty(JSON_PROPERTY_FILE_IDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileIdent(String fileIdent) {
    this.fileIdent = fileIdent;
  }


  public Reflection fileExt(String fileExt) {
    
    this.fileExt = fileExt;
    return this;
  }

   /**
   * Get fileExt
   * @return fileExt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_EXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileExt() {
    return fileExt;
  }


  @JsonProperty(JSON_PROPERTY_FILE_EXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileExt(String fileExt) {
    this.fileExt = fileExt;
  }


  public Reflection rootTable(ReflectionObject rootTable) {
    
    this.rootTable = rootTable;
    return this;
  }

   /**
   * Get rootTable
   * @return rootTable
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ROOT_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReflectionObject getRootTable() {
    return rootTable;
  }


  @JsonProperty(JSON_PROPERTY_ROOT_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRootTable(ReflectionObject rootTable) {
    this.rootTable = rootTable;
  }


  public Reflection services(List<ReflectionService> services) {
    
    this.services = services;
    return this;
  }

  public Reflection addServicesItem(ReflectionService servicesItem) {
    if (this.services == null) {
      this.services = new ArrayList<>();
    }
    this.services.add(servicesItem);
    return this;
  }

   /**
   * Get services
   * @return services
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReflectionService> getServices() {
    return services;
  }


  @JsonProperty(JSON_PROPERTY_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServices(List<ReflectionService> services) {
    this.services = services;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Reflection reflection = (Reflection) o;
    return Objects.equals(this.objects, reflection.objects) &&
        Objects.equals(this.enums, reflection.enums) &&
        Objects.equals(this.fileIdent, reflection.fileIdent) &&
        Objects.equals(this.fileExt, reflection.fileExt) &&
        Objects.equals(this.rootTable, reflection.rootTable) &&
        Objects.equals(this.services, reflection.services);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objects, enums, fileIdent, fileExt, rootTable, services);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Reflection {\n");
    sb.append("    objects: ").append(toIndentedString(objects)).append("\n");
    sb.append("    enums: ").append(toIndentedString(enums)).append("\n");
    sb.append("    fileIdent: ").append(toIndentedString(fileIdent)).append("\n");
    sb.append("    fileExt: ").append(toIndentedString(fileExt)).append("\n");
    sb.append("    rootTable: ").append(toIndentedString(rootTable)).append("\n");
    sb.append("    services: ").append(toIndentedString(services)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `objects` to the URL query string
    if (getObjects() != null) {
      for (int i = 0; i < getObjects().size(); i++) {
        if (getObjects().get(i) != null) {
          joiner.add(getObjects().get(i).toUrlQueryString(String.format("%sobjects%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `enums` to the URL query string
    if (getEnums() != null) {
      for (int i = 0; i < getEnums().size(); i++) {
        if (getEnums().get(i) != null) {
          joiner.add(getEnums().get(i).toUrlQueryString(String.format("%senums%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `file_ident` to the URL query string
    if (getFileIdent() != null) {
      try {
        joiner.add(String.format("%sfile_ident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFileIdent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `file_ext` to the URL query string
    if (getFileExt() != null) {
      try {
        joiner.add(String.format("%sfile_ext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFileExt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `root_table` to the URL query string
    if (getRootTable() != null) {
      joiner.add(getRootTable().toUrlQueryString(prefix + "root_table" + suffix));
    }

    // add `services` to the URL query string
    if (getServices() != null) {
      for (int i = 0; i < getServices().size(); i++) {
        if (getServices().get(i) != null) {
          joiner.add(getServices().get(i).toUrlQueryString(String.format("%sservices%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

