/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.string;

import java.util.List;
import java.util.Locale;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class LowerExpression<T, R>
extends AbstractFunctionExpression<T, String> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowNulls().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    public LowerExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public String apply(T value) {
        R arg = this.evaluateChild(0, value, this._typeValidator);
        if (arg == null) {
            return null;
        }
        String converted = DateTimeConverter.isDateTime(arg) ? DateTimeConverter.toStringMapper().apply(arg) : String.valueOf(arg);
        return converted.toLowerCase(Locale.US);
    }
}

