/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.Ticker;
import org.apache.qpid.server.transport.network.TransportActivity;

public class ServerIdleReadTimeoutTicker
implements Ticker {
    private final TransportActivity _transport;
    private final int _readDelay;
    private final ServerNetworkConnection _connection;

    public ServerIdleReadTimeoutTicker(ServerNetworkConnection connection, TransportActivity transport, int readDelay) {
        if (readDelay <= 0) {
            throw new IllegalArgumentException("Read delay should be positive");
        }
        this._connection = connection;
        this._transport = transport;
        this._readDelay = readDelay;
    }

    @Override
    public int getTimeToNextTick(long currentTime) {
        long nextTime = this._transport.getLastReadTime() + (long)this._readDelay;
        return (int)(nextTime - (this._connection.getScheduledTime() > 0L ? this._connection.getScheduledTime() : currentTime));
    }

    @Override
    public int tick(long currentTime) {
        int timeToNextTick = this.getTimeToNextTick(currentTime);
        if (timeToNextTick <= 0) {
            this._transport.readerIdle();
        }
        return timeToNextTick;
    }
}

