/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.sasl;

import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.network.security.sasl.SASLEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLReceiver
extends SASLEncryptor
implements ExceptionHandlingByteBufferReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SASLReceiver.class);
    private ExceptionHandlingByteBufferReceiver delegate;
    private byte[] netData;

    public SASLReceiver(ExceptionHandlingByteBufferReceiver delegate) {
        this.delegate = delegate;
    }

    @Override
    public void closed() {
        this.delegate.closed();
    }

    @Override
    public void exception(Throwable t) {
        this.delegate.exception(t);
    }

    @Override
    public void received(ByteBuffer buf) {
        if (this.isSecurityLayerEstablished()) {
            while (buf.hasRemaining()) {
                int length = Math.min(buf.remaining(), this.getRecvBuffSize());
                buf.get(this.netData, 0, length);
                try {
                    byte[] out = this.getSaslClient().unwrap(this.netData, 0, length);
                    this.delegate.received(ByteBuffer.wrap(out));
                }
                catch (SaslException e) {
                    throw new SenderException("SASL Sender, Error occurred while encrypting data", e);
                }
            }
        } else {
            this.delegate.received(buf);
        }
    }

    @Override
    public void securityLayerEstablished() {
        this.netData = new byte[this.getRecvBuffSize()];
        LOGGER.debug("SASL Security Layer Established");
    }
}

